/*
 * Decompiled with CFR 0.152.
 */
package capjte.test;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Principale {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String OS_ARCHI = System.getProperty("os.arch");
    public static String IP;

    public static String getTailleDisque() {
        File f = new File("/");
        return String.valueOf(f.getTotalSpace());
    }

    public static List<String> getIps() {
        ArrayList<String> ips = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface interfaceN = interfaces.nextElement();
                Enumeration<InetAddress> ienum = interfaceN.getInetAddresses();
                while (ienum.hasMoreElements()) {
                    InetAddress ia = ienum.nextElement();
                    String adress = ia.getHostAddress().toString();
                    if (adress.length() < 16 && !adress.startsWith("127")) {
                        System.out.println("IP:" + ia.getHostAddress());
                    }
                    ips.add(adress);
                }
            }
        }
        catch (Exception e) {
            System.out.println("pas de carte reseau");
            e.printStackTrace();
        }
        return ips;
    }

    public static String getMacAdresses() {
        try {
            ArrayList list = new ArrayList();
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            System.out.println("Boucle sur la liste des reseaaux...");
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                Enumeration<InetAddress> ienum = network.getInetAddresses();
                while (ienum.hasMoreElements()) {
                    InetAddress ia = ienum.nextElement();
                    String adress = ia.getHostAddress().toString();
                    StringBuilder adress2 = new StringBuilder();
                    byte[] byArray = ia.getAddress();
                    int n = byArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        adress2.append(String.format("%02X", b));
                        ++n2;
                    }
                    System.out.println(String.valueOf(network.getName()) + ":" + adress);
                    if (adress.length() >= 16) continue;
                    byte[] mac = network.getHardwareAddress();
                    StringBuilder sb = new StringBuilder();
                    if (mac == null) continue;
                    byte[] byArray2 = mac;
                    int n3 = mac.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        byte b = byArray2[n4];
                        sb.append(String.format("%02X", b));
                        ++n4;
                    }
                    System.out.println("L'adresse mac pour l'ip " + ia.getHostAddress() + " est: " + sb.toString());
                }
            }
            return "";
        }
        catch (SocketException s) {
            System.out.println("ERREUR" + s.getMessage());
            s.printStackTrace();
            return "";
        }
    }

    public static void main(String[] args) {
        try {
            IP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        Principale.getIps();
        Principale.getMacAdresses();
        System.out.println("Taille du disque:" + Principale.getTailleDisque());
        System.out.println("nom du systeme:" + OS_NAME);
        System.out.println("version du systeme:" + OS_VERSION);
        System.out.println("Architecture du systeme:" + OS_ARCHI);
    }
}

