#!/bin/sh
# ------------------------------------------------------------------
# VISUAL TAXE PRO
# Script de lancement du vtp-manager
# ------------------------------------------------------------------
# Historique
# 07/05/2010
# -> modif commande du lancement en mode traces 
# 26/04/2010
# -> permet de lancer avec option traces pour avoir démarrage avec
#    les traces dans un terminal, sinon start ou stop
# ------------------------------------------------------------------

# variables
VC_PARAM1=`echo $1 | tr 'A-Z' 'a-z'`

# selection du type d'action et definition de la commande
case $VC_PARAM1 in
    start)
        VC_COMMANDE="nohup /etc/init.d/vtp-manager start &>/dev/null"
        ;;
    stop) 
        VC_COMMANDE="/etc/init.d/vtp-manager stop"
        ;;
    traces) 
        #VC_COMMANDE="nohup xterm -e '/etc/init.d/vtp-manager start;read' &>/dev/null &"
	VC_COMMANDE="/etc/init.d/vtp-manager start"
        ;;
    *)
        echo "Usage: $0 start|stop|traces"
        exit 127
        ;;
esac

# Detection de la version de Linux
USE_SUDO=0
if [ -f /etc/lsb-release ];
then
    if [ `grep -E '^DISTRIB_ID=[a-zA-Z]?buntu$' /etc/lsb-release | wc -l` != "0" ];
    then
        USE_SUDO=1
    fi
fi

# Gestion d'un message de demande de mot de passe
if [ $USE_SUDO != "1" ];
then
    if [ `whoami` != "root" ];
    then
        echo "Saisissez le mot de passe root."
    fi
else
    echo "Saisissez votre mot de passe."
fi

# action
if [ $USE_SUDO != "1" ];
then
    su - -c "$VC_COMMANDE"
else
    sudo $VC_COMMANDE
fi
sleep 5
