#!/bin/sh
#------------------------------------------------------------------------------
# script-import.sh
# version 1.00 - 20/06/2011
#------------------------------------------------------------------------------
# Script d'import des tables d'un opérateur donné
#------------------------------------------------------------------------------

echo "Argument reçu : " $1

VC_ARG1=""
VC_ARG1=$1
VREF=""
VFICHIER_TABLE=""
VFICHIER_SCRIPT=""

#------------------------------------------------------------------------------
# fonction de traitement de chaque fichier
function_traitement()
{

  if [ -f $VFICHIER_TABLE ]
  then

    if [ -f $VFICHIER_SCRIPT ]
    then

	echo " "
	echo "-> traitement de " $VREF

	#modification du script psql

	echo "-> modification du fichier de script psql, on ajoute le fichier de données"
	sed -e "s|#2#|$VFICHIER_TABLE.temp|g" $VFICHIER_SCRIPT > $VFICHIER_SCRIPT.temp

	echo "-> modification du fichier de script psql, on remplace le numéro de l'opérateur"
	sed -i s/#1#/$VC_ARG1/g $VFICHIER_SCRIPT.temp

	#modification du fichier de données

	echo "-> modification du fichier des données, on supprime les lignes vides"
	sed '/^$/d' $VFICHIER_TABLE > $VFICHIER_TABLE.temp

	echo "-> modification du fichier des données, on remplace le numéro de l'opérateur"
	sed -i s/#1#/$VC_ARG1/g $VFICHIER_TABLE.temp

	echo "-> modification du fichier des données, on remplace les virgules par des points"
	sed -i s/,/./g $VFICHIER_TABLE.temp

	echo "-> modification du fichier des données, on remplace les caractères accentués"
	sed 'y/àçéèëêïîöôùüûÀÇÉÈËÊÏÎÖÔÙÜÛ/aceeeeiioouuuACEEEEIIOOUUU/'  $VFICHIER_TABLE.temp

	#lancement du script
	echo "-> lancement du script de psql"
	/opt/PostgreSQL/8.3/bin/psql --host=localhost --dbname=visual_taxe_pro --port=5499 --username=sa1 --file=$VFICHIER_SCRIPT.temp

    fi

  fi

}

#------------------------------------------------------------------------------
# main du script

clear
echo " "
echo "COGIS NETWORKS"
echo "Script d'import des grammaires tarifaires"

## Vérifier si on est root, si ce n'est pas le cas on quitte
#if [ $(whoami) != 'root' ]; then
#    echo " "
#    echo "Vous devez etre super-utilisateur pour executer ce script."
#    echo "ou lancez ce script à l'aide de su ou sudo."
#    echo "L'installation est annulee."
#    echo " "
#    echo "Appuyez sur <enter> pour continuer."
#    read V
#    exit 0
#fi

## Choix de l'opérateur
#echo " "
#echo "Indiquez le numéro d'opérateur pour lequel vous désirez effectuer l'import"
#echo -n "Votre choix ? "
#read VC_ARG1

# Detection du chemin absolu du script
echo " "
echo "-> détection du chemin du script"
VC_DIRLOC=$(dirname $0)
if [ "${VC_DIRLOC#/}" = "${VC_DIRLOC}" ]
then
	VC_DIRLOC=$(pwd)/${VC_DIRLOC}
fi
cd $VC_DIRLOC
export VC_DIRLOC
echo "-> chemin détecté : " $VC_DIRLOC

#suppression anciens fichiers
echo "-> suppression des anciens fichiers"
rm -rf $VC_DIRLOC/*.temp

# traitement de reftarifnat
VREF="Tarif nationaux"
VFICHIER_TABLE=$VC_DIRLOC/saiop_tarifs-nationaux.csv
VFICHIER_SCRIPT=$VC_DIRLOC/psql_tarifs-nationaux
function_traitement

# traitement de reftarifint
VREF="Tarifs internationaux"
VFICHIER_TABLE=$VC_DIRLOC/saiop_tarifs-internationaux.csv
VFICHIER_SCRIPT=$VC_DIRLOC/psql_tarifs-internationaux
function_traitement

# traitement de refmargint
VREF="Marguerite internationale"
VFICHIER_TABLE=$VC_DIRLOC/saiop_marguerite-internationale.csv
VFICHIER_SCRIPT=$VC_DIRLOC/psql_marguerite-internationale
function_traitement

# traitement de refmargnat
VREF="Marguerite nationale"
VFICHIER_TABLE=$VC_DIRLOC/saiop_marguerite-nationale.csv
VFICHIER_SCRIPT=$VC_DIRLOC/psql_marguerite-nationale
function_traitement

# traitement de refmargcourt
VREF="Marguerite numéros courts"
VFICHIER_TABLE=$VC_DIRLOC/saiop_marguerite-courts.csv
VFICHIER_SCRIPT=$VC_DIRLOC/psql_marguerite-courts
function_traitement

#suppression anciens fichiers
echo "-> suppression des fichiers temporaires"
rm -rf $VC_DIRLOC/*.temp

#fin
echo " "
echo "-> fin du script"
echo " "
exit 0

