#!/bin/sh
#-----------------------------------------------------------
# VISUAL TAXE PRO
# Création du menu, sous-menus et icones
#-----------------------------------------------------------
# Historique
# 26/04/2010
# -> création du script
#-----------------------------------------------------------

# Architecture du menu
# VTPRO
# -> raccourci accéder à VTPRO
# -> sous-menu documentations
#	-> raccourci configuration
#	-> raccourci installation
#	-> raccourci annuaire
#	-> raccourci communications
#	-> raccourci tableaux de bord
# -> raccourci lancement superviseur
# -> sous-menu vtp-manager
#	-> raccourci lancer vtp-manager
#	-> raccourci lancer vtp-manager en mode traces
#	-> raccourci arrêter vtp-manager
# -> sous-menu superviseur
#	-> raccourci lancer superviseur
#	-> raccourci lancer superviseur en mode traces
# -> sous-menu tomcat
#	-> raccourci lancer tomcat
#	-> raccourci arrêter tomcat
# -> sous-menu PostgreSQL
#	-> raccourci lancer postgresql
#	-> raccourci arrêter postgresql
#	-> raccourci pgadmin

# fonction pour le menu principal
function_menu1()
{
	# On créé le menu PRINCIPAL et les RACCOURCIS qui y sont contenus
	"$INSTALLDIRXDG/installer/xdg/xdg-desktop-menu" $INSTALLETAPE --mode system --noupdate --novendor \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro.directory" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-ihm-start.desktop" \
	|| _warn "Failed to create the top level menu"
}

# fonction pour les sous-menus
function_menusX()
{

	# On créé le sous-menu POSTGRESQL et les RACCOURCIS qui y sont contenus
	"$INSTALLDIRXDG/installer/xdg/xdg-desktop-menu" $INSTALLETAPE --mode system --noupdate --novendor \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro.directory" \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro-postgresql.directory" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-postgresql-start.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-postgresql-stop.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-postgresql-manager-start.desktop" \
	|| _warn "Failed to create POSTGRESQL menu"

	# On créé le sous-menu SUPERVISEUR et les RACCOURCIS qui y sont contenus
	"$INSTALLDIRXDG/installer/xdg/xdg-desktop-menu" $INSTALLETAPE --mode system --noupdate --novendor \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro.directory" \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro-superviseur.directory" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-superviseur-start.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-superviseur-start-traces.desktop" \
	|| _warn "Failed to create SUPERVISEUR menu"

	# On créé le sous-menu TOMCAT et les RACCOURCIS qui y sont contenus
	"$INSTALLDIRXDG/installer/xdg/xdg-desktop-menu" $INSTALLETAPE --mode system --noupdate --novendor \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro.directory" \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro-tomcat.directory" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-tomcat-start.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-tomcat-stop.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-tomcat-start-traces.desktop" \
	|| _warn "Failed to create TOMCAT menu"

	# On créé le sous-menu VTP-MANAGER et les RACCOURCIS qui y sont contenus
	"$INSTALLDIRXDG/installer/xdg/xdg-desktop-menu" $INSTALLETAPE --mode system --noupdate --novendor \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro.directory" \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro-vtpmanager.directory" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-vtpmanager-start.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-vtpmanager-start-traces.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-vtpmanager-stop.desktop" \
	|| _warn "Failed to create VTPMANAGER menu"

	# On créé le sous-menu DOCUMENTATION et les RACCOURCIS qui y sont contenus
	"$INSTALLDIRXDG/installer/xdg/xdg-desktop-menu" $INSTALLETAPE --mode system --noupdate --novendor \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro.directory" \
	"$INSTALLDIRVTPRO/xdg-directory/vtpro-doc.directory" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-doc-annuaire.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-doc-communications.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-doc-configuration.desktop" \
	"$INSTALLDIRVTPRO/xdg-desktop/vtpro-doc-tableau.desktop" \
	|| _warn "Failed to create DOCUMENTATION menu"

}

_warn() {
    echo $1
    WARN=2
}

# variables
INSTALLETAPE=$1
INSTALLDIRXDG="/usr/local/vtp-manager/xdg"
INSTALLDIRVTPRO="/usr/local/vtp-manager/xdg"
WARN=0

# On créé les ressources des icones
cd "$INSTALLDIRVTPRO/xdg-icones"
for i in `ls *.png`
do
	"$INSTALLDIRXDG/installer/xdg/xdg-icon-resource" install --novendor --size 32 $i
done

# on supprime le menu et les sous-menus
if [ $INSTALLETAPE = "uninstall" ]
then
	function_menusX
	sleep 3
	function_menu1
	sleep 5
elif [ $INSTALLETAPE = "install" ]
then
	# On créé le menu et les sous-menus	
	function_menu1
	sleep 3
	function_menusX
	sleep 5
fi

"$INSTALLDIRXDG/installer/xdg/xdg-desktop-menu" forceupdate --mode user
sleep 3
"$INSTALLDIRXDG/installer/xdg/xdg-desktop-menu" forceupdate --mode system
sleep 3

exit 0
