#!/bin/sh
# ------------------------------------------------------------------
# VTPUTIL
# ------------------------------------------------------------------
# Arguments
# $1 = services
#	$2 = postgresql, tomcat, vtp-manager
#	$3 = start, stop, status, create, delete, control	
# $1 = tracesvtprm, tracesvtpls
# 	$2 = non utilisé
#	$3 = non utilisé
# ------------------------------------------------------------------

V_NOMSERVICEARGUMENT=""
V_ACTIONARGUMENT=""
V_RESULT=""
V_TEMP=""
V_NOMSERVICEPSQL=postgresql-8.4
V_NOMSERVICEVTP=vtp-manager
V_NOMSERVICETOMCAT=tomcat
V_CHEMINSERVICEPSQL=/etc/init.d/postgresql-8.4
V_CHEMINSERVICEVTP=/etc/init.d/vtp-manager
V_CHEMINSERVICETOMCAT=/etc/init.d/tomcat

# ------------------------------------------------------------------
# Déclaration des fonctions
# ------------------------------------------------------------------

# démarrage du service
function_service_start()
{
	if [ "$V_NOMSERVICEARGUMENT" = "vtp-manager" ]
	then
		/usr/bin/nohup $V_CHEMINSERVICEVTP start &>/dev/null
		V_RESULT="le service a été lancé"
	fi

	if [ "$V_NOMSERVICEARGUMENT" = "postgresql" ]
	then
		/bin/service $V_NOMSERVICEPSQL start
	fi

	if [ "$V_NOMSERVICEARGUMENT" = "tomcat" ]
	then
		/etc/init.d/$V_NOMSERVICETOMCAT start
	fi
}

# ------------------------------------------------------------------

# arret du service
function_service_stop()
{
	if [ "$V_NOMSERVICEARGUMENT" = "postgresql" ]
	then
		/bin/service $V_NOMSERVICEPSQL stop
	fi
	if [ "$V_NOMSERVICEARGUMENT" = "vtp-manager" ]
	then
		/etc/init.d/$V_NOMSERVICEVTP stop
	fi
	if [ "$V_NOMSERVICEARGUMENT" = "tomcat" ]
	then
		/etc/init.d/$V_NOMSERVICETOMCAT stop
	fi

}

# ------------------------------------------------------------------

# status du service
function_service_status()
{
	if [ "$V_NOMSERVICEARGUMENT" = "vtp-manager" ]
	then
		V_COMPTLIGNES=$(ps aux | grep "[j]ar /usr/local/vtp-manager/manager.jar /usr/local/vtp-manager" | wc -l)
	fi

	if [ "$V_NOMSERVICEARGUMENT" = "postgresql" ]
	then
		V_COMPTLIGNES=$(ps aux | grep "/opt/PostgreSQL/8.4/bin/[p]ostgres" | wc -l)
	fi

	if [ "$V_NOMSERVICEARGUMENT" = "tomcat" ]
	then
		V_COMPTLIGNES=$(ps aux | grep D[c]atalina.base=/usr/local/tomcat | wc -l)
	fi
	if [ "$V_COMPTLIGNES" = "0" ]
	then
		V_RESULT="le service ne fonctionne pas"
	else
		V_RESULT="le service fonctionne"			
	fi
}

# ------------------------------------------------------------------

# création du démarrage automatique du service
function_service_create()
{
	if [ "$V_NOMSERVICEARGUMENT" = "vtp-manager" ]
	then
		ln -sf /etc/init.d/vtp-manager /etc/rc0.d/K96vtp-manager
		ln -sf /etc/init.d/vtp-manager /etc/rc1.d/K96vtp-manager
		ln -sf /etc/init.d/vtp-manager /etc/rc2.d/S96vtp-manager
		ln -sf /etc/init.d/vtp-manager /etc/rc3.d/S96vtp-manager
		ln -sf /etc/init.d/vtp-manager /etc/rc4.d/S96vtp-manager
		ln -sf /etc/init.d/vtp-manager /etc/rc5.d/S96vtp-manager
		ln -sf /etc/init.d/vtp-manager /etc/rc6.d/K96vtp-manager
	fi

	if [ "$V_NOMSERVICEARGUMENT" = "postgresql" ]
	then
		/sbin/chkconfig $V_NOMSERVICEPSQL on
	fi

	if [ "$V_NOMSERVICEARGUMENT" = "tomcat" ]
	then
		/bin/ln -sf /etc/init.d/tomcat /etc/rc0.d/K95tomcat
	        /bin/ln -sf /etc/init.d/tomcat /etc/rc1.d/K95tomcat
	        /bin/ln -sf /etc/init.d/tomcat /etc/rc2.d/S95tomcat
	        /bin/ln -sf /etc/init.d/tomcat /etc/rc3.d/S95tomcat
                /bin/ln -sf /etc/init.d/tomcat /etc/rc4.d/S95tomcat
                /bin/ln -sf /etc/init.d/tomcat /etc/rc5.d/S95tomcat
                /bin/ln -sf /etc/init.d/tomcat /etc/rc6.d/K95tomcat
	fi

	V_RESULT="Activation demarrage automatique effectuee"

}

# ------------------------------------------------------------------

# suppression du démarrage automatique du service
function_service_delete()
{
	if [ "$V_NOMSERVICEARGUMENT" = "vtp-manager" ]
	then
		/bin/rm -rf /etc/rc0.d/K96vtp-manager
		/bin/rm -rf /etc/rc1.d/K96vtp-manager
		/bin/rm -rf /etc/rc2.d/S96vtp-manager
		/bin/rm -rf /etc/rc3.d/S96vtp-manager
		/bin/rm -rf /etc/rc4.d/S96vtp-manager
		/bin/rm -rf /etc/rc5.d/S96vtp-manager
		/bin/rm -rf /etc/rc6.d/K96vtp-manager
	fi

	if [ "$V_NOMSERVICEARGUMENT" = "postgresql" ]
	then
		/sbin/chkconfig $V_NOMSERVICEPSQL off
	fi

	if [ "$V_NOMSERVICEARGUMENT" = "tomcat" ]
	then
		/bin/rm /etc/rc0.d/K95tomcat
		/bin/rm /etc/rc1.d/K95tomcat
		/bin/rm /etc/rc2.d/S95tomcat
		/bin/rm /etc/rc3.d/S95tomcat
		/bin/rm /etc/rc4.d/S95tomcat
		/bin/rm /etc/rc5.d/S95tomcat
		/bin/rm /etc/rc6.d/K95tomcat
	fi

	V_RESULT="Désactivation demarrage automatique effectuee"

}

# ------------------------------------------------------------------

# controle du démarrage automatique du service
function_service_control()
{
	if [ "$V_NOMSERVICEARGUMENT" = "vtp-manager" ]
	then
		V_TEMP=/etc/rc2.d/S96vtp-manager
	fi
	if [ "$V_NOMSERVICEARGUMENT" = "postgresql" ]
	then
		V_TEMP=/etc/rc2.d/S85postgresql-8.4
	fi
	if [ "$V_NOMSERVICEARGUMENT" = "tomcat" ]
	then
		V_TEMP=/etc/rc2.d/S95tomcat
	fi

	if [ -f $V_TEMP ]
	then
		V_RESULT="Demarrage automatique actif"
	else
		V_RESULT="Demarrage automatique inactif"		
	fi
}


# ------------------------------------------------------------------
# Script
# ------------------------------------------------------------------

if [ "$1" = "" ]
then
	exit
fi

if [ "$1" = "services" ]
then

	V_NOMSERVICEARGUMENT=$2
	V_ACTIONARGUMENT=$3

	if [ "$V_ACTIONARGUMENT" = "start" ]
	then
		function_service_start
		echo $V_RESULT
	fi

	if [ "$V_ACTIONARGUMENT" = "stop" ]
	then
		function_service_stop
		echo $V_RESULT
	fi

	if [ "$V_ACTIONARGUMENT" = "status" ]
	then
		function_service_status
		echo $V_RESULT
	fi

	if [ "$V_ACTIONARGUMENT" = "create" ]
	then
		function_service_create
		echo $V_RESULT
	fi

	if [ "$V_ACTIONARGUMENT" = "delete" ]
	then
		function_service_delete
		echo $V_RESULT
	fi

	if [ "$V_ACTIONARGUMENT" = "control" ]
	then
		function_service_control
		echo $V_RESULT
	fi

fi

if [ "$1" = "tracesvtprm" ]
then
	/bin/rm -rf /root/vtpro*
fi

if [ "$1" = "tracesvtpls" ]
then
	/bin/ls -d /root/* | /bin/grep vtpro*
fi

exit
