#!/bin/sh
# ------------------------------------------------------------------
# VISUAL TAXE PRO/EXPRESS
# Script de restauration
# ------------------------------------------------------------------

#==============================================================================
# DEMARRAGE DU SCRIPT
#==============================================================================

# controle si chemin script est avec espaces
# si oui on refuse l'installation
if [[ "$0" =~ " " ]]
then
	echo "Au sein du chemin ou est situe l'installeur, figure un espace"
	echo "le nom des repertoires doit etre sans espaces"
	echo " "
	echo "Fin du programme d'installation"
	echo " "
	echo "Appuyez sur une touche pour quitter"
	read n
	exit 0
fi

# Detection du chemin absolu du script
VC_DIRLOC=$(dirname $0)
if [ "${VC_DIRLOC#/}" = "${VC_DIRLOC}" ]
then
	VC_DIRLOC=$(pwd)/${VC_DIRLOC}
fi
cd $VC_DIRLOC
export VC_DIRLOC

# gestion du lancement
# si présence de -traces alors c'est l'installation, sinon lancement installation avec traces
if [ "$1" = "-force" ]
then
	echo "Restauration des données de Visual Taxe Pro/Express"
else
	VC_LOGS=$HOME/vtpro-restaure_"$(date +%Y%m%d%H%M%S)".log
	export VC_LOGS
	if [ "$1" = "-console" -o "$2" = "-console" ]
	then
		sh $VC_DIRLOC/install.sh -force 2>&1 | tee $VC_LOGS
	else
		if [ "$DISPLAY" != "" ]
		then
			# on contrôle que le package xterm existe
			rpm -qa | grep xterm > /dev/null 2>&1
			if  [ $? -ne 0 ]
			then
				# existe pas, donc on lance sans xterm
				sh $VC_DIRLOC/restaure.sh -force 2>&1 | tee $VC_LOGS
			else
				# existe
				xterm -geometry 145x45 -fg black -bg white -T "Restauration des données de Visual Taxe Pro/Express" -e "sh $VC_DIRLOC/restaure.sh -force $VC_STOPMEM 2>&1 | tee $VC_LOGS" &
			fi
		else
			sh $VC_DIRLOC/restaure.sh -force 2>&1 | tee $VC_LOGS
		fi
	fi
	exit 0
fi

# variables
VC_DIRVTPM=/usr/local/vtp-manager
VC_DIRSQL=/opt/PostgreSQL/8.3
VC_CHEMINJRE=""
$VC_DIRSQL=""
VMESSAGECONFIRMATION=""
VC_ORIGINEJRE_PACK="jre1.6.0_31"
VC_DESTINATIONJRE_REP="/usr/lib"
VC_TEMPPACKAGEJRE=""
VCREP=""

#==============================================================================
# DECLARATION DES FONCTIONS
#==============================================================================

#------------------------------------------------------------------------------

# fonction pour arrêter les process de VTPRO
function_stop_vtpro()
{
	# On arrête le manager
	/etc/init.d/vtp-manager stop > /dev/null
	sleep 5

	# Arrêt "propre" des composants
	if [ -f $VC_DESTINATIONJRE_REP/$VC_ORIGINEJRE_PACK/bin/java ]
	then
		if [ -f $VC_DIRVTPM/stopprocessus.jar ]
		then
			$VC_DESTINATIONJRE_REP/$VC_ORIGINEJRE_PACK/bin/java -jar $VC_DIRVTPM/stopprocessus.jar > /dev/null 2>&1
			sleep 10
		fi
	fi

	# Au cas où on kill les process
	# On kill les process et on supprime les fichiers pid
	for PID in `ps aux | grep $VC_DIRVTPM | awk '{print $2}'`
	do
		kill $PID 2>/dev/null
		sleep 1
	done
	sleep 5
	rm -f /var/run/manager.pid 2>/dev/null
	rm -f /var/run/superviseur.pid 2>/dev/null
	rm -f /var/run/telecollecteur.pid 2>/dev/null
	rm -f /var/run/collecteur.pid 2>/dev/null
	rm -f /var/run/planificateur.pid 2>/dev/null
	rm -f /var/run/roomservice.pid 2>/dev/null
	rm -f /var/run/comengine.pid 2>/dev/null
	rm -f /var/run/stopprocessus.pid 2>/dev/null

}

#------------------------------------------------------------------------------

# fonction pour détecter la dernière version supportée de JRE/JDK
function_detect_jre_jdk()
{
if [ -f /usr/lib/jre1.6.0_31/bin/java ]
then
	VC_TEMPPACKAGEJRE="\/usr\/lib\/jre1.6.0_31"
else
	VC_TEMPPACKAGEJRE="\/usr\/lib\/jdk1.6.0_10"
	VC_ORIGINEJRE_PACK="jdk1.6.0_10"
	VC_DESTINATIONJRE_REP="/usr/lib"
fi
}

#------------------------------------------------------------------------------

# fonction qui gère le dialogue de demande de confirmation sur les actions manuelles
function_dialogue_confirmation()
{
       	# installation/desinstallation manuelle   
        VCREP=0
        until [ "$VCREP" = "1" -o "$VCREP" = "2" ]
        do
            clear
            echo $VMESSAGECONFIRMATION
            echo "1 - oui"
            echo "2 - non"
            echo -n "Votre choix ? "
            read VCREP
        done
	VMESSAGECONFIRMATION=""
}

#------------------------------------------------------------------------------

# fonction qui permet de détecter le chemin de postgresql installé
function_detect_chemin_postgresql()
{

	echo "-> détection du chemin de POSTGRESQL"
	VC_DETECTION_CHEMIN_PSQL=""
	# détection du fichier packages.conf
	if [ -f $VC_DIRVTPM/conf/packages.conf ]
	then
		# on extrait de packages.conf le chemin
		VC_DETECTION_CHEMIN_PSQL=$(cat $VC_DIRVTPM/conf/packages.conf | grep postgre-chemin | cut -d= -f2)
		# on vérifie si chemin valide
		if [ -f $VC_DETECTION_CHEMIN_PSQL/bin/psql ]
		then
			# valide
			echo "-> chemin trouvé pour POSTGRESQL : "$VC_DETECTION_CHEMIN_PSQL
		else
			# invalide
			VC_DETECTION_CHEMIN_PSQL=""
			echo "-> chemin trouvé pour POSTGRESQL invalide : "$VC_DETECTION_CHEMIN_PSQL
		fi
	fi
	
	# si résultat vide
	if [ "$VC_DETECTION_CHEMIN_PSQL" = "" ]
	then
		VC_DETECTION_CHEMIN_PSQL="/opt/PostgreSQL/8.3"
		echo "-> chemin retenu pour POSTGRESQL : "$VC_DETECTION_CHEMIN_PSQL
	fi

	# affectation
	VC_DIRSQL=$VC_DETECTION_CHEMIN_PSQL

}


#==============================================================================
# SCRIPT PRINCIPAL
#==============================================================================

# Vérifier si on est root, si ce n'est pas le cas on quitte
clear
if [ $(whoami) != 'root' ]; then
    echo " "
    echo "Vous devez etre super-utilisateur pour executer ce script."
    echo "ou lancez ce script à l'aide de su ou sudo."
    echo "L'installation est annulee."
    echo " "
    echo "Appuyez sur <enter> pour continuer."
    read V
    exit 0
fi

# Detection du chemin absolu du script
VC_DIRLOC=$(dirname $0)
if [ "${VC_DIRLOC#/}" = "${VC_DIRLOC}" ]
then
	VC_DIRLOC=$(pwd)/${VC_DIRLOC}
fi
cd $VC_DIRLOC

# Confirmation
VMESSAGECONFIRMATION="Confirmez-vous la restauration des données ... ?"
function_dialogue_confirmation
echo " "
if [ "$VCREP" = "1" ]
then

	# détection du chemin de postgreSQL
	function_detect_chemin_postgresql

	# détection java
	function_detect_jre_jdk

	# restauration des archives
	echo " "       
	echo "-> copie des archives, veuillez patienter ..."
	cp -fr $VC_DIRLOC/archive/* $VC_DIRVTPM/archive
	sleep 10
	echo "-> copie terminée"

	# restauration des sauvegardes
	echo " "       
	echo "-> copie des sauvegardes, veuillez patienter ..."
	cp -fr $VC_DIRLOC/backup/* $VC_DIRVTPM/backup
	sleep 10
	echo "-> copie terminée"

	# restauration des fichiers de configuration
	echo " "       
	echo "-> copie des fichiers de configuration, veuillez patienter ..."
	cp -fr $VC_DIRLOC/conf/* $VC_DIRVTPM/conf
	sleep 10
	echo "-> copie terminée"

	# restauration des dernières sauvegardes
	echo " "       
	echo "-> copie des dernières sauvegardes, veuillez patienter ..."
	cp -fr $VC_DIRLOC/postgresql/* $VC_DIRVTPM/backup
	sleep 10
	echo "-> copie terminée"

	# restauration des bases
	echo " "       
	echo "-> restauration des bases dans PostgreSQL, veuillez patienter ..."
	echo "-> arrêt de vtpro"
	function_stop_vtpro
	sleep 5
	if [ -f $VC_DIRVTPM/backup/vtp_config.bak ]
	then
		echo "-> suppression en cascade de la base CONFIG"
		LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql --host=localhost --dbname=visual_taxe_pro --port=5499 --username=sa1 --command "DROP SCHEMA vtp_config CASCADE;"
		sleep 3
		echo "-> restauration de la base CONFIG"
		LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro' -p 5499 -U postgres $VC_DIRVTPM/backup/vtp_config.bak 
		sleep 3
	else
		echo "-> impossible de restaurer la base CONFIG, la sauvegarde est manquante"
	fi
	if [ -f $VC_DIRVTPM/backup/vtp_stats.bak ]
	then
		echo "-> suppression en cascade de la base STATS"
		LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql --host=localhost --dbname=visual_taxe_pro --port=5499 --username=sa1 --command "DROP SCHEMA vtp_stats CASCADE;"
		sleep 3
		echo "-> restauration de la base STATS"
		LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro' -p 5499 -U postgres $VC_DIRVTPM/backup/vtp_stats.bak 
		sleep 3
	else
		echo "-> impossible de restaurer la base STATS, la sauvegarde est manquante"
	fi
	if [ -f $VC_DIRVTPM/backup/vtp_room.bak ]
	then
		echo "-> suppression en cascade de la base ROOM"
		LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql --host=localhost --dbname=visual_taxe_pro --port=5499 --username=sa1 --command "DROP SCHEMA vtp_room CASCADE;"
		sleep 3
		echo "-> restauration de la base ROOM"
		LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro' -p 5499 -U postgres $VC_DIRVTPM/backup/vtp_room.bak 
		sleep 3
	else
		echo "-> impossible de restaurer la base ROOM, la sauvegarde est manquante"
	fi
	echo "-> démarrage de vtpro"
	nohup /etc/init.d/vtp-manager start >/dev/null 2>&1 &
	sleep 10
	echo "-> restauration terminée"

else
	echo " "
	echo "Restauration annulée"
fi

echo " "
if [ "$VC_LOGS" != "" ]
then
	echo " "
	echo "Vous pouvez trouver les logs de la restauration dans "$VC_LOGS
fi
echo " "
echo " "
echo "Appuyez sur la touche <enter> pour continuer."
read V
exit 0

