#!/bin/sh
VC_VERSION_VTPRO="4.60D.04"

# ------------------------------------------------------------------
# VISUAL TAXE PRO/EXPRESS
# Script d'installation, mise à jour et désinstallation
# ------------------------------------------------------------------
# Arguments acceptés : install.sh argument
#   -memoire : empêche la détection de la mémoire
#   -console : si execution du script via une console sans graphique
# ------------------------------------------------------------------

#==============================================================================
# DEMARRAGE DU SCRIPT
#==============================================================================

# controle si chemin script est avec espaces
# si oui on refuse l'installation
if [[ "$0" =~ " " ]]
then
	echo "Au sein du chemin ou est situe l'installeur, figure un espace"
	echo "le nom des repertoires doit etre sans espaces"
	echo " "
	echo "Fin du programme d'installation"
	echo " "
	echo "Appuyez sur une touche pour quitter"
	read n
	exit 0
fi

# Detection du chemin absolu du script
VC_DIRLOC=$(dirname $0)
if [ "${VC_DIRLOC#/}" = "${VC_DIRLOC}" ]
then
	VC_DIRLOC=$(pwd)/${VC_DIRLOC}
fi
cd $VC_DIRLOC
export VC_DIRLOC


# gestion du lancement
# si présence de -traces alors c'est l'installation, sinon lancement installation avec traces
if [[ $* = *"-force"* ]]; then
	echo "Installation de VISUAL TAXE PRO/EXPRESS"
else

	#gestion argument à forcer
	VC_CMDPROG1=""
	if [[ $* = *"-install"* ]]; then
		VC_CMDPROG1="-install"
	fi
	if [[ $* = *"-uninstall"* ]]; then
		VC_CMDPROG1="-uninstall"
	fi
	if [[ $* = *"-update"* ]]; then
		VC_CMDPROG1="-update"
	fi
	VC_CMDPROG2=""
	if [[ $* = *"-c2icompact"* ]]; then
		VC_CMDPROG2="-c2icompact"
	fi
	if [[ $* = *"-vtpbox"* ]]; then
		VC_CMDPROG2="-vtpbox"
	fi

	VC_LOGS=$HOME/vtpro-install_"$(date +%Y%m%d%H%M%S)".log
	export VC_LOGS
	if [[ "$VC_CMDPROG1" != "" ]]; then
		sh $VC_DIRLOC/install.sh $VC_CMDPROG1 $VC_CMDPROG2 -force 2>&1 | tee $VC_LOGS
	else
	if [[ "-console" =~ "$*" ]]; then
		sh $VC_DIRLOC/install.sh $VC_CMDPROG1 $VC_CMDPROG2 -force 2>&1 | tee $VC_LOGS
	else
		if [ "$DISPLAY" != "" ]
		then
			# on contrôle que le package xterm existe
			rpm -qa | grep xterm > /dev/null 2>&1
			if  [ $? -ne 0 ]
			then
				# existe pas, donc on lance sans xterm
				sh $VC_DIRLOC/install.sh $VC_CMDPROG1 $VC_CMDPROG2 -force 2>&1 | tee $VC_LOGS
			else
				# existe
				xterm -geometry 145x45 -fg black -bg white -T "Installation de Visual Taxe Pro/Express" -e "sh $VC_DIRLOC/install.sh $VC_CMDPROG1 $VC_CMDPROG2 -force 2>&1 | tee $VC_LOGS" &
			fi
		else
			sh $VC_DIRLOC/install.sh $VC_CMDPROG1 $VC_CMDPROG2 -force 2>&1 | tee $VC_LOGS
		fi
	fi
	fi
	exit 0
fi

# variables
VC_INSTJDK=$HOME/INSTVTPROJDK
VC_INSTTMC=$HOME/INSTVTPROTMC
VC_INSTSQL=$HOME/INSTVTPROSQL
VC_INSTVTP=$HOME/INSTVTPROVTP
VC_DIRVTPM=/usr/local/vtp-manager
VC_DIRSQL=/usr/local/vtp-postgre
VC_DIRTCAT=/usr/local/vtp-tomcat
VC_DIRJRE=/usr/local/vtp-jre
VC_AM7450=0
# versions des packages
VC_VERSION_JRE="1.8.0_201"
VC_VERSION_TOMCAT="7.0.92"
VC_VERSION_POSTGRE="9.3.25-1"
# Pour la sauvegarde des données
VC_CHNOM=$HOME/vtpro_sauve_
VC_CHDAT=`echo $(date +%Y%m%d%H%M%S)` 
VC_VERSIONPRESENTEVTP=""
# Variables diverses
VC_MODIF_JRE="N"
VC_MODIF_TOMCAT="N"
VC_MODIF_POSTGRE="N"
VC_MODIF_VTPRO="N"
VC_PSQL83PHP_EXIST=""
VC_C2ICOMPACT=""
VC_VTPBOX=""
VC_CHEMIN_DETECTION_TOMCAT=""
#nom des services
VC_NOMSERVICE_TOMCAT="vtp-tomcat"
VC_NOMSERVICE_POSTGRESQL="vtp-postgre"
VC_NOMSERVICE_VTPMANAGER="vtp-manager"
# VC_MODIF_JRE
# -> permet de savoir si une version de JRE a été installée ou mise a jour ou non
#    si vide rien n'a été fait au niveau de ce package
# VC_MODIF_TOMCAT
# -> permet de savoir si une version de TOMCAT a été installée ou mise a jour ou non
#    si vide rien n'a été fait au niveau de ce package
# VC_MODIF_POSTGRE
# -> permet de savoir si une version de POSTGRE a été installée ou mise a jour ou non
#    si vide rien n'a été fait au niveau de ce package
# VC_MODIF_VTPRO
# -> permet de savoir si une version de VTPRO a été installée ou mise a jour ou non
#    si vide rien n'a été fait au niveau de ce package
# VC_C2ICOMPACT
# -> permet de savoir si on est sur c2icompact (1) ou non (0)
# VC_VTPBOX
# -> permet de savoir si on est sur c2vtpbox (1) ou non (0)


#==============================================================================
# DECLARATION DES FONCTIONS
#==============================================================================

#------------------------------------------------------------------------------
# fonction de restauration des bases
function_restauration_sauvegardes()
{

VC_SQLHOTE=localhost
VC_SQLPORT=5499
VC_SQLDBNAME=visual_taxe_pro
VC_SQLUSERNAME=sa1

echo "-> début de la restauration des bases sauvegardées"
echo "-> Base VTP_CONFIG"
VC_FICHIER=${VC_CHNOM}${VC_CHDAT}/postgresql/vtp_config.bak
echo "-> Fichier : "$VC_FICHIER
sizeo=$(du -b $VC_FICHIER | cut -f1)
if [ -f $VC_FICHIER ] && [ "$sizeo" -gt "0" ]
then
	echo "-> suppression en cascade de la base"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql --host=$VC_SQLHOTE --port=$VC_SQLPORT --dbname=$VC_SQLDBNAME --username=$VC_SQLUSERNAME --no-password --command "DROP SCHEMA vtp_config CASCADE;"
	sleep 3
	echo "-> restauration de la base"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore --host=$VC_SQLHOTE --port=$VC_SQLPORT --dbname=$VC_SQLDBNAME --username=$VC_SQLUSERNAME --no-password $VC_FICHIER 
	sleep 3
else
	echo "ERREUR - Fichier de la base VTP_CONFIG a restaurer inexistant ou taille a 0 octets"
fi

echo "-> Base VTP_STATS"
VC_FICHIER=${VC_CHNOM}${VC_CHDAT}/postgresql/vtp_stats.bak 
echo "-> Fichier : "$VC_FICHIER
sizeo=$(du -b $VC_FICHIER | cut -f1)
if [ -f $VC_FICHIER ] && [ "$sizeo" -gt "0" ]
then
	echo "-> suppression en cascade de la base"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql --host=$VC_SQLHOTE --port=$VC_SQLPORT --dbname=$VC_SQLDBNAME --username=$VC_SQLUSERNAME --no-password --command "DROP SCHEMA vtp_stats CASCADE;"
	sleep 3
	echo "-> restauration de la base"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore --host=$VC_SQLHOTE --port=$VC_SQLPORT --dbname=$VC_SQLDBNAME --username=$VC_SQLUSERNAME --no-password $VC_FICHIER
	sleep 3
else
	echo "ERREUR - Fichier de la base VTP_STATS a restaurer inexistant ou taille a 0 octets"
fi

echo "-> Base VTP_ROOM"
VC_FICHIER=${VC_CHNOM}${VC_CHDAT}/postgresql/vtp_room.bak 
echo "-> Fichier : "$VC_FICHIER
sizeo=$(du -b $VC_FICHIER | cut -f1)
if [ -f $VC_FICHIER ] && [ "$sizeo" -gt "0" ]
then
	echo "-> suppression en cascade de la base"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql --host=$VC_SQLHOTE --port=$VC_SQLPORT --dbname=$VC_SQLDBNAME --username=$VC_SQLUSERNAME --no-password --command "DROP SCHEMA vtp_room CASCADE;"
	sleep 3
	echo "-> restauration de la base"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore --host=$VC_SQLHOTE --port=$VC_SQLPORT --dbname=$VC_SQLDBNAME --username=$VC_SQLUSERNAME --no-password $VC_FICHIER
	sleep 3
else
	echo "ERREUR - Fichier de la base VTP_ROOM a restaurer inexistant ou taille a 0 octets"
fi

echo "-> Base VTP_QUARTZ"
VC_FICHIER=${VC_CHNOM}${VC_CHDAT}/postgresql/vtp_quartz.bak 
echo "-> Fichier : "$VC_FICHIER
sizeo=$(du -b $VC_FICHIER | cut -f1)
if [ -f $VC_FICHIER ] && [ "$sizeo" -gt "0" ]
then
	echo "-> suppression en cascade de la base"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql --host=$VC_SQLHOTE --port=$VC_SQLPORT --dbname=$VC_SQLDBNAME --username=$VC_SQLUSERNAME --no-password --command "DROP SCHEMA vtp_quartz CASCADE;"
	sleep 3
	echo "-> restauration de la base"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore --host=$VC_SQLHOTE --port=$VC_SQLPORT --dbname=$VC_SQLDBNAME --username=$VC_SQLUSERNAME --no-password $VC_FICHIER
	sleep 3
else
	echo "ERREUR - Fichier de la base VTP_QUARTZ a restaurer inexistant ou taille a 0 octets"
fi


echo "-> gestion utilisateur ODBC"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql --host=$VC_SQLHOTE --port=$VC_SQLPORT --dbname=$VC_SQLDBNAME --username=$VC_SQLUSERNAME --no-password --file=$VC_DIRLOC/scripts/postgresql/odbc-psql
sleep 3

echo "-> fin de la restauration"

}
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# fonction d'installation de vtputil pour c2icompact
function_install_vtputilc2icompact()
{

# on vérifie que httpd existe via le service httpd
if [ "$VC_C2ICOMPACT" = "1" ]
then
	if [ -f /etc/init.d/httpd ]
	then
		# copie du répertoire vtputil
		rm -rf /var/www/cogis-vtputil
		cp -r $VC_DIRLOC/scripts/vtputil-c2icompact/cogis-vtputil /var/www
		chmod 777 -R /var/www/cogis-vtputil
		# copie du fichier de configuration pour http
		rm -rf /etc/httpd/conf.d/cogis-vtputil.conf
		cp $VC_DIRLOC/scripts/vtputil-c2icompact/cogis-vtputil/cogis-vtputil.conf /etc/httpd/conf.d
		# on modifie le nom du service de postgre dans action.sh
		if [ -f /opt/PostgreSQL/8.3/bin/psql ]
		then
			VC_NOMSERVICEPSQL=postgresql-8.3
		fi
		if [ -f /opt/PostgreSQL/8.4/bin/psql ]
		then
			VC_NOMSERVICEPSQL=postgresql-8.4
		fi
		sed -i 's/#SERVICEPSQL#/$VC_NOMSERVICEPSQL/g' /var/www/cogis-vtputil/action.sh
		# on ajouter les autorisations dans /etc/sudoers
		sed -i '/COGIS DEBUT/,/COGIS FIN/d' /etc/sudoers
		echo "###COGIS DEBUT###" >> /etc/sudoers
		echo "User_Alias      GRCOGIS = apache" >> /etc/sudoers
		echo "Defaults:GRCOGIS       !requiretty" >> /etc/sudoers
		echo "apache ALL=(root) NOPASSWD: /var/www/cogis-vtputil, /bin/sh, /etc/init.d, /root/vtpro*, /bin/rm, /usr/bin/nohup, /dev/null, /bin/ls, /bin/grep, /bin/ps, /usr/bin/wc" >> /etc/sudoers
		echo "###COGIS FIN###" >> /etc/sudoers
		# on recharge httpd
		service httpd reload
	fi
fi

}

#------------------------------------------------------------------------------
# fonction de désinstallation de vtputil pour c2icompact
function_uninstall_vtputilc2icompact()
{

# on vérifie que httpd existe via le service httpd
if [ "$VC_C2ICOMPACT" = "1" ]
then
	if [ -f /etc/init.d/httpd ]
	then
		# suppression du fichier de configuration pour http
		rm -rf /etc/httpd/conf.d/cogis-vtputil.conf
		# on recharge httpd
		service httpd reload
		# suppression du répertoire vtputil
		rm -rf /var/www/cogis-vtputil
		# on supprime les autorisations dans /etc/sudoers
		sed -i '/COGIS DEBUT/,/COGIS FIN/d' /etc/sudoers
	fi
fi

}

#------------------------------------------------------------------------------

# fonction specifique AASTRA C2iCompact
function_c2icompactinstall()
{

if [ "$VC_C2ICOMPACT" = "1" ]
then
	echo "-> application des paramètres par défaut pour AASTRA C2i Compact"
	# on met à 1 les threads du collecteur
	sed -i 's/nombre.thread=2/nombre.thread=1/g' /usr/local/vtp-manager/conf/conf.properties
	# on modifie adresse IP de la source tickets, on met 127.0.0.1
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U postgres -d visual_taxe_pro -c "UPDATE vtp_config.protocoleai SET adresse = '127.0.0.1' WHERE compteur = 1;"
	sleep 3
	# on modifie adresse IP de la source annuaire, on met 127.0.0.1
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U postgres -d visual_taxe_pro -c "UPDATE vtp_config.protocole SET cheminfichier = 'https://127.0.0.1:443/trf/backup/pc/tickets' WHERE compteur = 1;"
	sleep 3
	# on modifie le niveau de log
	sed -i -r 's/^log.level=.*$/log.level=off/g' /usr/local/vtp-manager/conf/conf.properties
	# on enleve le demarrage du service avec affichage dans console
	sed -i -r 's/^[\t]daemon.*$/\tdaemon $DAEMON $DAEMON_ARGS \&>\/dev\/null \&/g' /etc/init.d/vtp-manager
	# apache
	function_integration_AM7450
fi

}

#------------------------------------------------------------------------------

# fonction specifique AASTRA C2iCompact
function_c2icompactdeleteservices()
{

# on supprime les services
# si installation : systématique
# autre cas : non

if [ "$VC_C2ICOMPACT" = "1" ]
then
	if [ "$VCINSTALL" = "1" -o "$VCINSTALL" = "2" ]
	then
		echo "-> suppression dans /etc/init.d des services PSQL/TOMCAT/VTP"
		# vtp-manager
		rm -rf /etc/rc0.d/K96vtp-manager
		rm -rf /etc/rc1.d/K96vtp-manager
		rm -rf /etc/rc2.d/S96vtp-manager
		rm -rf /etc/rc3.d/S96vtp-manager
		rm -rf /etc/rc4.d/S96vtp-manager
		rm -rf /etc/rc5.d/S96vtp-manager
		rm -rf /etc/rc6.d/K96vtp-manager

		# postgre
		chkconfig $VC_NOMSERVICEPSQL off

		# tomcat
		rm -rf /etc/rc0.d/K95vtp-tomcat
		rm -rf /etc/rc1.d/K95vtp-tomcat
		rm -rf /etc/rc2.d/S95vtp-tomcat
		rm -rf /etc/rc3.d/S95vtp-tomcat
		rm -rf /etc/rc4.d/S95vtp-tomcat
		rm -rf /etc/rc5.d/S95vtp-tomcat
		rm -rf /etc/rc6.d/K95vtp-tomcat

		sleep 3
	fi
fi

}

#------------------------------------------------------------------------------


# fonction pour mettre a jour les variables selon 32 ou 64 bits
function_gestion_variables_3264()
{

# Variables pour JRE
# VC_ORIGINEJRE_REP
# -> chemin où est le package dans l'installeur
# VC_ORIGINEJRE_FILE
# -> nom du package JRE pour l'installation
# VC_ORIGINEJRE_PACK
# -> nom du répertoire une fois le package décompressé
# VC_DESTINATIONJRE_REP
# -> chemin où doit être stocké VC_ORIGINEJRE_PACK
# VC_DESTINATIONJRE_SED
# -> chemin complet de l'accès au JRE avec \ avant les / pour la commande sed
if [ "$VC_DETECT3264" = "32" ]
then
	VC_ORIGINEJRE_REP="outils32/jre"
	VC_ORIGINEJRE_FILE="jdk-8u201-linux-i586.tar.gz"
else
	VC_ORIGINEJRE_REP="outils64/jre"
	VC_ORIGINEJRE_FILE="jdk-8u201-linux-x64.tar.gz"
fi
VC_ORIGINEJRE_PACK="jdk1.8.0_201"
VC_DESTINATIONJRE_PACK="vtp-jre"
VC_DESTINATIONJRE_REP="/usr/local"
VC_DESTINATIONJRE_SED="\/usr\/local\/"$VC_DESTINATIONJRE_PACK
VC_TEMPPACKAGEJRE="\/usr\/lib\/jdk1.8.0_201"

# Variables pour TOMCAT
# VC_ORIGINEJRE_TOMCAT
# -> chemin où est le package dans l'installeur
# VC_ORIGINETOMCAT_FILE
# -> nom du package TOMCAT pour l'installation
# VC_ORIGINETOMCAT_PACK
# -> nom du répertoire une fois le package décompressé
# VC_DESTINATIONTOMCAT_REP
# -> chemin où doit être stocké VC_ORIGINEJRE_PACK
# VC_DESTINATIONTOMCAT_SED
# -> chemin complet de l'accès a TOMCAT avec \ avant les / pour la commande sed
if [ "$VC_DETECT3264" = "32" ]
then
	VC_ORIGINETOMCAT_REP="outils-communs/tomcat"
else
	VC_ORIGINETOMCAT_REP="outils-communs/tomcat"
fi
VC_ORIGINETOMCAT_FILE="apache-tomcat-7.0.92.tar.gz"
VC_ORIGINETOMCAT_PACK="apache-tomcat-7.0.92"
VC_DESTINATIONTOMCAT_REP="/usr/local/vtp-tomcat"
VC_DESTINATIONTOMCAT_SED="\/usr\/local\/vtp-tomcat"

# Variables pour POSTGRE
if [ "$VC_DETECT3264" = "32" ]
then
	VC_ORIGINEPSQL_REP="outils32/postgresql"
	VC_ORIGINEPSQL_FILE="postgresql-9.3.25-1-linux.run"
else
	VC_ORIGINEPSQL_REP="outils64/postgresql"
	VC_ORIGINEPSQL_FILE="postgresql-9.3.25-1-linux-x64.run"
fi

# Variables pour HTTPD
if [ "$VC_DETECT3264" = "32" ]
then
	VC_MODJKHTTPD_COMPLET="scripts/httpd/mod_jk-1.2.31-httpd-2.2.x_32bits.so"
else
	VC_MODJKHTTPD_COMPLET="scripts/httpd/mod_jk-1.2.31-httpd-2.2.x_64bits.so"
fi
# VC_MODJKHTTPD_COMPLET
# -> chemin+nom du fichier mod_jk pour httpd

}

#------------------------------------------------------------------------------
# fonction pour gerer le fichier des versions
function_gestion_versions()
{

echo "-> fichier de suivi des versions des logiciels"

if [ -f $VC_DIRVTPM/conf/packages.conf ]
then
	echo "-> modification du fichier"
else
	echo "-> copie du fichier et modification"
	cp -f $VC_DIRLOC/scripts/vtp-manager/packages.conf $VC_DIRVTPM/conf/
fi

if [ "$VC_MODIF_JRE" = "O" ]
then
	sed -i '/java-version/d' /usr/local/vtp-manager/conf/packages.conf
	tmp1=`echo "java-version=$VC_VERSION_JRE" >> /usr/local/vtp-manager/conf/packages.conf`
	sed -i '/java-chemin/d' /usr/local/vtp-manager/conf/packages.conf
	tmp1=`echo "java-chemin=$VC_DESTINATIONJRE_REP/$VC_DESTINATIONJRE_PACK" >> /usr/local/vtp-manager/conf/packages.conf`
fi

if [ "$VC_MODIF_TOMCAT" = "O" ]
then
	sed -i '/tomcat-version/d' /usr/local/vtp-manager/conf/packages.conf
	tmp1=`echo "tomcat-version=$VC_VERSION_TOMCAT" >> /usr/local/vtp-manager/conf/packages.conf`
	sed -i '/tomcat-chemin/d' /usr/local/vtp-manager/conf/packages.conf
	tmp1=`echo "tomcat-chemin=$VC_DESTINATIONTOMCAT_REP" >> /usr/local/vtp-manager/conf/packages.conf`
fi

if [ "$VC_MODIF_POSTGRE" = "O" ]
then
	sed -i '/postgre-version/d' /usr/local/vtp-manager/conf/packages.conf
	tmp1=`echo "postgre-version=$VC_VERSION_POSTGRE" >> /usr/local/vtp-manager/conf/packages.conf`
fi

if [ "$VC_MODIF_VTPRO" = "O" ]
then
	sed -i '/vtpmanager-version/d' /usr/local/vtp-manager/conf/packages.conf
	tmp1=`echo "vtpmanager-version=$VC_VERSION_VTPRO" >> /usr/local/vtp-manager/conf/packages.conf`
fi

}

#------------------------------------------------------------------------------

# fonction pour deecter la derniee version supportee de JRE/JDK
function_detect_jre_jdk()
{

tmp4="echecjre"
if [ -f $VC_DIRVTPM/conf/packages.conf ]
then
	tmp0=`cat $VC_DIRVTPM/conf/packages.conf | grep 'java-chemin='`
	tmp1=`expr index "$tmp0" =`
	tmp2=${tmp0:$tmp1}
	#echo "JRE inscrit dans packages.conf : "$tmp2
	if [ "$tmp2" != "" ]
	then
		tmp3=${tmp2//\//\\\/}
		VC_TEMPPACKAGEJRE=$tmp3
		VC_DESTINATIONJRE_REP="/usr/lib"
		until [ "$tmp1" = "0" ]
		do
			tmp1=`expr index "$tmp0" /`
			tmp2=${tmp0:$tmp1}
			tmp0=$tmp2
		done
		VC_ORIGINEJRE_PACK=$tmp0
		if [ -f $VC_ORIGINEJRE_PACK/bin/java ]
		then
			tmp4="echecjre"
			echo "-> echec de la detection du chemin JRE/JDK"
		fi
	else
		tmp4="echecjre"
		echo "-> echec de la detection du chemin JRE/JDK"
	fi
else
	tmp4="echecjre"
	echo "-> echec de la detection du chemin JRE/JDK"
fi

if [ "$tmp4" != "" ]
then
	if [ -f /usr/lib/jdk1.6.0_10/bin/java ]
	then
		VC_TEMPPACKAGEJRE="\/usr\/lib\/jdk1.6.0_10"
		VC_ORIGINEJRE_PACK="jdk1.6.0_10"
		VC_DESTINATIONJRE_REP="/usr/lib"
	fi
	if [ -f /usr/lib/jre1.6.0_31/bin/java ]
	then
		VC_TEMPPACKAGEJRE="\/usr\/lib\/jre1.6.0_31"
		VC_ORIGINEJRE_PACK="jre1.6.0_31"
		VC_DESTINATIONJRE_REP="/usr/lib"
	fi
	if [ -f /usr/lib/jre1.6.0_35/bin/java ]
	then
		VC_TEMPPACKAGEJRE="\/usr\/lib\/jre1.6.0_35"
		VC_ORIGINEJRE_PACK="jre1.6.0_35"
		VC_DESTINATIONJRE_REP="/usr/lib"
	fi
	if [ -f /usr/lib/jre1.6.0_37/bin/java ]
	then
		VC_TEMPPACKAGEJRE="\/usr\/lib\/jre1.6.0_37"
		VC_ORIGINEJRE_PACK="jre1.6.0_37"
		VC_DESTINATIONJRE_REP="/usr/lib"
	fi
	if [ -f /usr/local/vtp-jre/bin/java ]
	then
		VC_TEMPPACKAGEJRE="\/usr\/local\/vtp-jre"
		VC_ORIGINEJRE_PACK="vtp-jre"
		VC_DESTINATIONJRE_REP="/usr/local"
	fi

fi
echo "-> detection du chemin JRE/JDK : "$VC_TEMPPACKAGEJRE

}

#------------------------------------------------------------------------------

# controle de version VTPRO
function_controle_version_vtpro()
{
	if [ -f $VC_DIRVTPM/conf/packages.conf ]
	then
		tmp0=`cat $VC_DIRVTPM/conf/packages.conf | grep 'vtpmanager-version='`
		VC_VERSIONPRESENTEVTP=${tmp0##*=}
		echo "-> version actuellement installée : "$VC_VERSIONPRESENTEVTP
	else
		VC_VERSIONPRESENTEVTP="4.00A.00"
		echo "-> fichier de suivi des versions non détecté, version considérée "$VC_VERSIONPRESENTEVTP
	fi
	if [ "$VC_VERSIONPRESENTEVTP" ">" "$VC_VERSION_VTPRO" ]
	then
		echo " "
		echo " "
		echo "La version actuellement installée est plus récente"
		echo "que la version que vous vous apprêtez à installer"
		echo " "
		echo "Mise à jour impossible !"
		echo " "
		echo "Fin du programme"
		echo " "
		echo "Appuyez sur une touche pour continuer"
		read n
		exit 0
	fi
	
}

#------------------------------------------------------------------------------

# fonction pour arrêter les process de VTPRO
function_stop_vtpro()
{

	echo "-> detection du JRE en cours"
	function_detect_jre_jdk

	# On arrête le manager
	echo "-> arret du manager"
	sh /etc/init.d/vtp-manager stop > /dev/null
	sleep 5

	# Arrêt "propre" des composants
	echo "-> arret des composants"
	if [ -f $VC_DESTINATIONJRE_REP/$VC_DESTINATIONJRE_PACK/bin/java ]
	then
		if [ -f $VC_DIRVTPM/stopprocessus.jar ]
		then
			$VC_DESTINATIONJRE_REP/$VC_DESTINATIONJRE_PACK/bin/java -jar $VC_DIRVTPM/stopprocessus.jar > /dev/null 2>&1
			sleep 10
		fi
	fi

	# Au cas où on kill les process
	# On kill les process et on supprime les fichiers pid
	for PID in `ps aux | grep $VC_DIRVTPM | awk '{print $2}'`
	do
		kill $PID 2>/dev/null
		sleep 1
	done
	sleep 5
	rm -f /var/run/manager.pid 2>/dev/null
	rm -f /var/run/superviseur.pid 2>/dev/null
	rm -f /var/run/telecollecteur.pid 2>/dev/null
	rm -f /var/run/collecteur.pid 2>/dev/null
	rm -f /var/run/planificateur.pid 2>/dev/null
	rm -f /var/run/roomservice.pid 2>/dev/null
	rm -f /var/run/comengine.pid 2>/dev/null
	rm -f /var/run/sipservice.pid 2>/dev/null
	rm -f /var/run/stopprocessus.pid 2>/dev/null

}

#------------------------------------------------------------------------------

# fonction pour arrêter les process TOMCAT
function_stop_tomcat()
{

	echo "-> arret de TOMCAT en cours"
	# On arrête tomcat
	#if [ -f /etc/init.d/tomcat ]
	#then
	#	/etc/init.d/tomcat stop 1>/dev/null 2>&1 &
	#else
	#	/etc/init.d/vtp-tomcat stop 1>/dev/null 2>&1 &
	#fi
	/etc/init.d/$VC_NOMSERVICE_TOMCAT stop 1>/dev/null 2>&1 &
	sleep 10
	# On kill les process et on supprime les fichiers pid
	for PID in `ps aux | grep $VC_DESTINATIONTOMCAT_REP | awk '{print $2}'`
	do
		kill $PID 2>/dev/null
		sleep 1
	done
	sleep 5
}

#------------------------------------------------------------------------------

# fonction pour démarrer le manager
function_start_vtpmanager()
{

	echo "-> demarrage de VTP en cours"
	if [ "$VCINSTALL" = "3" ]
	then
		# suite mise à jour
		nohup $VC_DESTINATIONJRE_REP/$VC_DESTINATIONJRE_PACK/bin/java -jar $VC_DIRVTPM/manager.jar $VC_DIRVTPM $VC_DESTINATIONJRE_REP/$VC_DESTINATIONJRE_PACK/bin/ $VC_DIRSQL/bin stop &>/dev/null 2>&1 &
	else
		# normal
		nohup /etc/init.d/vtp-manager start >/dev/null 2>&1 &

	fi
}

#------------------------------------------------------------------------------

# fonction pour démarrer tomcat
function_start_tomcat()
{
	echo "-> demarrage de TOMCAT en cours"
	nohup /etc/init.d/$VC_NOMSERVICE_TOMCAT start >/dev/null 2>&1 &
	
}

#------------------------------------------------------------------------------

# fonction pour sauvegarder les données
function_sauve_vtpro()
{
        echo "-> copie de sauvegarde en cours ..."
        mkdir ${VC_CHNOM}${VC_CHDAT}
	mkdir ${VC_CHNOM}${VC_CHDAT}/backup
	mkdir ${VC_CHNOM}${VC_CHDAT}/archive
	mkdir ${VC_CHNOM}${VC_CHDAT}/postgresql
	mkdir ${VC_CHNOM}${VC_CHDAT}/conf
	sleep 1

#	# si PostgreSQL 8.3, alors si pas de postgresql.conf, on force les librairies
#	VC_LIBPSQL=$(echo $VC_DIRSQL | grep "8.3")
#	if [ "$VC_LIBPSQL" != "" ]
#	then
#		# on est en PostgreSQL 8.3
#		# on teste si postgresql-8.3.conf est présent
#		if [ -f /etc/ld.so.conf.d/postgresql-8.3.conf ]
#		then
#			# présent
#			VC_LIBPSQL=""
#		else
#			# pas présent
#			VC_LIBPSQL="LD_LIBRARY_PATH="$VC_DIRSQL/lib" "
#		fi
#	else
#		VC_LIBPSQL=""
#	fi

	echo "-> sauvegarde de la base vtp_stats de PostgreSQL en cours ..."
	$(LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_dump -h localhost -p 5499 -U sa1 -i -F c  -f ${VC_CHNOM}${VC_CHDAT}/postgresql/vtp_stats.bak -n vtp_stats visual_taxe_pro)
	sleep 1
	echo "-> sauvegarde de la base vtp_config de PostgreSQL en cours ..."
	$(LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_dump -h localhost -p 5499 -U sa1 -i -F c  -f ${VC_CHNOM}${VC_CHDAT}/postgresql/vtp_config.bak -n vtp_config visual_taxe_pro)
	sleep 1
	echo "-> sauvegarde de la base vtp_room de PostgreSQL en cours ..."
	$(LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_dump -h localhost -p 5499 -U sa1 -i -F c  -f ${VC_CHNOM}${VC_CHDAT}/postgresql/vtp_room.bak -n vtp_room visual_taxe_pro)
	sleep 1
	echo "-> sauvegarde de la base vtp_quartz de PostgreSQL en cours ..."
	$(LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_dump -h localhost -p 5499 -U sa1 -i -F c  -f ${VC_CHNOM}${VC_CHDAT}/postgresql/vtp_quartz.bak -n vtp_quartz visual_taxe_pro)
	sleep 1
	echo "-> copie des fichiers de configuration en cours ..."
	cp -fr $VC_DIRVTPM/conf/* ${VC_CHNOM}${VC_CHDAT}/conf
	if [ "$VCINSTALL" = "4" -o "$VCINSTALL" = "5" ]
	then
	    echo "-> copie des sauvegardes existantes en cours ..."
	    cp -fr $VC_DIRVTPM/backup/* ${VC_CHNOM}${VC_CHDAT}/backup
	    sleep 3
	    echo "-> copie des archives existantes en cours ..."
	    cp -fr $VC_DIRVTPM/archive/* ${VC_CHNOM}${VC_CHDAT}/archive
	    sleep 3
	fi
	echo "-> copie du fichier de restauration ..."
	cp -f $VC_DIRLOC/scripts/vtp-manager/restaure.sh ${VC_CHNOM}${VC_CHDAT}/restaure.sh
}

#------------------------------------------------------------------------------

# fonction qui gère le dialogue de demande de confirmation sur les actions manuelles
function_dialogue_confirmation()
{
       	# installation/desinstallation manuelle   
        VCREP=0
        until [ "$VCREP" = "1" -o "$VCREP" = "2" ]
        do
            clear
            echo $VMESSAGECONFIRMATION
            echo "1 - oui"
            echo "2 - non"
            echo -n "Votre choix ? "
            read VCREP
        done
	VMESSAGECONFIRMATION=""
}

#------------------------------------------------------------------------------

# fonction qui gère l'installation et désinstallation des raccourcis
function_raccourcis()
{
	echo "-> gestion du menu et des raccourcis ..."
	sh $VC_DIRVTPM/xdg/createshortcuts.sh uninstall
	# si installation/mise à jour
	if [ "$VCINSTALL" = "1" -o "$VCINSTALL" = "2" -o "$VCINSTALL" = "3" ]
	then
		sh $VC_DIRVTPM/xdg/createshortcuts.sh install
	fi
}

#------------------------------------------------------------------------------

# fonction qui permet de détecter la distribution LINUX
function_detection_linux()
{
	#detection de l'OS
	echo " "
	echo "Identification de la distribution linux présente"
	VCOS=0
	for fichier in /etc/issue, /etc/redhat-release
	do
		VCOSTMP=$(grep -i -c "red hat" /etc/issue)
	   	if [ "$VCOSTMP" = "1" ]
		then
			VCOS="1"
			echo "-> distribution détectée : REDHAT"
			break
		fi
		VCOSTMP=$(grep -i -c "centos" /etc/issue)
	   	if [ "$VCOSTMP" = "1" ]
		then
			VCOS="1"
			echo "-> distribution détectée : CENTOS"
			break
		fi
		VCOSTMP=$(grep -i -c "centos" /etc/redhat-release)
	   	if [ "$VCOSTMP" = "1" ]
		then
			VCOS="1"
			echo "-> distribution détectée : CENTOS"
			break
		fi
		VCOSTMP=$(grep -i -c "ubuntu" /etc/issue)
	   	if [ "$VCOSTMP" = "1" ]
		then
			VCOS="2"
			echo "-> distribution détectée : UBUNTU"
			break
		fi
		VCOSTMP=$(grep -i -c "fedora" /etc/redhat-release)
	   	if [ "$VCOSTMP" = "1" ]
		then
			VCOS="1"
			echo "-> distribution détectée : FEDORA"
			break
		fi
	done

	if [ "$VCOS" = "1" ]
	then
#		#on recherche les OS plus supportes
		VFINSUPPORT=0
#		#VCOSTMP=$(cat /etc/redhat-release | grep -i -c centos.*5.[0-9])
#		#if [ "$VCOSTMP" = "1" ]
#		#then
#			VFINSUPPORT=1
#		#fi
#		#VCOSTMP=$(cat /etc/redhat-release | grep -i -c redhat.*5.[0-9])
#		#if [ "$VCOSTMP" = "1" ]
#		#then
#			VFINSUPPORT=1
#		fi
#		VCOSTMP=$(cat /etc/redhat-release | grep -i -c fedora.*release.*1[0-7])
#		if [ "$VCOSTMP" = "1" ]
#		then
#			VFINSUPPORT=1
#		fi
	else
		echo "Le programme d'installation n'a pu identifier la presente distribution linux"

		# Choix manuel de Linux
		until [ "$VCOS" = "1" -o "$VCOS" = "2" ]
		do
			echo " "
			echo "Indiquez sur quelle version de Linux vous installez VISUAL TAXE PRO"
			echo "1 - RedHat / CentOS / Fedora"
			echo "2 - Ubuntu"
			echo -n "Votre choix ? "
			read VCOS
		done
	fi

}

#------------------------------------------------------------------------------

# fonction qui permet de détecter la quantité de mémoire du serveur
function_detection_memoire()
{

	# verification si mémoire suffisante
	echo " "
	VC_TOTMEM=`echo $(grep MemTotal: /proc/meminfo) | cut -d' ' -f2` 
	echo "Quantité memoire RAM detectee : " $VC_TOTMEM " octets, minimum requis 1850000 octets"
	
	VC_TOTMEM="2000000"
	
	if [ "$1" = "-memoire" -o "$2" = "-memoire" ]
	then
		# ici on ne teste pas la mémoire
		echo "Limitation mémoire non gérée (argument mem)"
	else
		if [ $VC_TOTMEM -lt 1850000 ]
		then
			echo "-> Quantite de mémoire RAM insuffisante"
			echo " "
			echo "Fin de l'installation"
			echo " "
		   	echo "Appuyez sur <enter> pour continuer."
			read V
		   	exit 0
		else
			echo "-> Quantite de mémoire RAM suffisante"
		fi	
	fi

}

#------------------------------------------------------------------------------

# fonction qui d'intégrer l'accès à VTPRO via le HTTPS de AM7450
function_integration_AM7450()
{
	echo " "
	#echo "Integration en cours, veuillez patienter ..."
	#echo "-> installation des fichiers ..."
	##cp -f $VC_DIRLOC/scripts/httpd/mod_jk.so /etc/httpd/modules
	#cp -f $VC_DIRLOC/$VC_MODJKHTTPD_COMPLET /etc/httpd/modules/mod_jk.so
	#cp -f $VC_DIRLOC/scripts/httpd/vtpro.conf /etc/httpd/conf.d
	#cp -f $VC_DIRLOC/scripts/httpd/worker.properties /etc/httpd/conf
	#echo "-> sauvegarde de ssl.conf ..."
	#cp -f /etc/httpd/conf.d/ssl.conf /etc/httpd/conf.d/ssl-conf.old
	#echo "-> suppression d'une eventuelle precedente integration ..."
	#sed '/^JkMount \/VisualTaxeWeb/d' /etc/httpd/conf.d/ssl.conf > /etc/httpd/conf.d/tempcogis.ssl.conf
	#cp -f /etc/httpd/conf.d/tempcogis.ssl.conf /etc/httpd/conf.d/ssl.conf
	#echo "-> modification de ssl.conf ..."
	#sed 's/<\/VirtualHost>/JkMount \/VisualTaxeWeb ajp13\nJkMount \/VisualTaxeWeb\/* ajp13\n<\/VirtualHost>/g' /etc/httpd/conf.d/tempcogis.ssl.conf > /etc/httpd/conf.d/ssl.conf
	#rm -f /etc/httpd/conf.d/tempcogis.ssl.conf
	#echo "-> relance de AM7450 sans coupure des connexions courantes ..."
	#sleep 3
	#sh /etc/init.d/httpd reload >/dev/null 2>&1 &
	#sleep 10
	#echo "-> fin du traitement"
}

#------------------------------------------------------------------------------

# fonction qui permet de modifier le chemin de PSQL dans les scripts
function_gestion_modif_postgresql_install()
{
	sed -i "s|COGIS-CHEMIN-POSTGRESQL|$VC_DIRSQL|g" /etc/init.d/vtp-manager
	sed -i "s|COGIS-CHEMIN-POSTGRESQL|$VC_DIRSQL|g" /etc/init.d/$VC_NOMSERVICE_TOMCAT	
	sed -i '/postgre-chemin/d' $VC_DIRVTPM/conf/packages.conf
	tmp1=`echo "postgre-chemin=$VC_DIRSQL" >> $VC_DIRVTPM/conf/packages.conf`
}

#------------------------------------------------------------------------------

# fonction qui permet de corriger le conflit php entre PostgreSQL 8.3 et 8.4 si AM7450 présent
function_corrige_conflit_postgresql8384AM7450()
{
VC_NEPLUSUTILISER="1"
if [ "$VC_NEPLUSUTILISER" = "2" ]
then
	echo "aaaaaaa : "$VC_NEPLUSUTILISER
	echo "-> correctif sur conflit php entre PostgreSQL 8.3 et 8.4 pour AM7450"
	# on vérifie que AM7450 est présent
	if [ "$VC_AM7450" = "1" ]
	then
		# on vérifie si le postgresql installé en rpm est bien en 8.4
		VC_PSQL83PHP_EXIST=$(/usr/bin/psql --version | grep 8.3 | awk '{print $3}')
		if [ "$VC_PSQL83PHP_EXIST" = "" ]
		then
			sed -i "1iexport LD_LIBRARY_PATH=$VC_DIRSQL/lib" /root/.bashrc
			echo "-> pas de postgresql natif 8.3 installé, on retire donc la librairie 8.3"
			rm -rf /etc/ld.so.conf.d/postgresql-8.3.conf
			sleep 5
			ldconfig
			sleep 15
			sh /etc/init.d/httpd restart >/dev/null 2>&1 &
			sleep 10
			# on ajoute le chemin de la libraire à vtp-manager si elle n'est pas déjà présente
			VC_TEMP=$(cat /etc/init.d/vtp-manager | grep '^export LD_LIBRARY_PATH=')
			if [ "$VC_TEMP" = "" ]
			then
				sed -i "2iexport LD_LIBRARY_PATH=$VC_DIRSQL/lib" /etc/init.d/vtp-manager
			fi
			# on ajoute le chemin de la libraire à vtp-manager si elle n'est pas déjà présente
			VC_TEMP=$(cat /etc/init.d/$VC_NOMSERVICE_TOMCAT | grep '^export LD_LIBRARY_PATH=')
			if [ "$VC_TEMP" = "" ]
			then
				sed -i "2iexport LD_LIBRARY_PATH=$VC_DIRSQL/lib" /etc/init.d/$VC_NOMSERVICE_TOMCAT
			fi
		else
			echo "-> aucun conflit car PostgreSQL natif en 8.3"
		fi
	else
		echo "-> aucun conflit car AM7450 absent"	
	fi
fi
}

#------------------------------------------------------------------------------

# fonction qui permet de détecter le chemin de postgresql installé
function_detect_chemin_postgresql()
{

	echo "-> détection du chemin/service de POSTGRESQL"
	VC_DETECTION_CHEMIN_PSQL=""
	VC_DETECTION_SERVICE_PSQL=""
	# détection du fichier packages.conf
	if [ -f $VC_DIRVTPM/conf/packages.conf ]
	then
		# on extrait de packages.conf le chemin
		VC_DETECTION_CHEMIN_PSQL=$(cat $VC_DIRVTPM/conf/packages.conf | grep postgre-chemin | cut -d= -f2)
		# on vérifie si chemin valide
		if [ -f $VC_DETECTION_CHEMIN_PSQL/bin/psql ]
		then
			# valide
			echo "-> chemin trouvé pour POSTGRESQL : "$VC_DETECTION_CHEMIN_PSQL
		else
			# invalide
			VC_DETECTION_CHEMIN_PSQL=""
			echo "-> chemin trouvé pour POSTGRESQL invalide : "$VC_DETECTION_CHEMIN_PSQL
		fi
	fi
	
	# si résultat vide
	if [ "$VC_DETECTION_CHEMIN_PSQL" = "" ]
	then
	
		if [ -f /opt/PostgreSQL/8.3/bin/psql ]
		then
			VC_DETECTION_CHEMIN_PSQL="/opt/PostgreSQL/8.3"
		fi
	
		if [ -f /opt/PostgreSQL/8.4/bin/psql ]
		then
			VC_DETECTION_CHEMIN_PSQL="/opt/PostgreSQL/8.4"
		fi
		echo "-> chemin retenu pour POSTGRESQL : "$VC_DETECTION_CHEMIN_PSQL
	fi

	# détection du nom du service
	if [ -f /opt/PostgreSQL/8.3/bin/psql ]
	then
		VC_DETECTION_SERVICE_PSQL="postgresql-8.3"
	fi
	if [ -f /opt/PostgreSQL/8.4/bin/psql ]
	then
		VC_DETECTION_SERVICE_PSQL="postgresql-8.4"
	fi
	if [ -f /etc/init.d/vtp-postgre ]
	then
		VC_DETECTION_SERVICE_PSQL="vtp-postgre"
	fi	
	echo "-> nom de service retenu pour POSTGRESQL : "$VC_DETECTION_SERVICE_PSQL
	
	# affectation
	VC_DIRSQL=$VC_DETECTION_CHEMIN_PSQL

}

#------------------------------------------------------------------------------

# fonction qui permet l'installation de JRE
function_install_jre()
{
        echo " "       
        echo "Installation de JRE"
	if [ -f $VC_DIRLOC/$VC_ORIGINEJRE_REP/$VC_ORIGINEJRE_FILE ]
	then
	    echo "-> traitements en cours, veuillez patienter ..."
	    echo "-> suppression du JRE existant"
	    rm -rf $VC_DESTINATIONJRE_REP/$VC_DESTINATIONJRE_PACK
            echo "-> copie des fichiers d'installation ..."
            echo "CCC : "$VC_INSTJDK
			rm -rf $VC_INSTJDK
            sleep 3
            mkdir $VC_INSTJDK
            sleep 1
			
			echo "DDD : "$VC_DIRLOC
			echo "EEE : "$VC_ORIGINEJRE_REP
			
            cp $VC_DIRLOC/$VC_ORIGINEJRE_REP -R $VC_INSTJDK
            echo "-> Decompactage ..."
            cd $VC_INSTJDK/jre
            chmod 777 $VC_ORIGINEJRE_FILE
            tar xzf $VC_ORIGINEJRE_FILE
            sleep 3
			
			echo "FFF : "$VC_ORIGINEJRE_PACK

            chmod 777 $VC_ORIGINEJRE_PACK
            chmod 777 -R $VC_ORIGINEJRE_PACK/*
            echo "-> Installation ..."
            mkdir $VC_DESTINATIONJRE_REP/$VC_DESTINATIONJRE_PACK
            sleep 5
            cp -fr $VC_ORIGINEJRE_PACK/* $VC_DESTINATIONJRE_REP/$VC_DESTINATIONJRE_PACK
            sleep 3
            echo "-> Suppression des fichiers d'installation ..."
	    cd $VC_DIRLOC
	    sleep 1
            rm -rf $VC_INSTJDK
            sleep 3
            echo "-> fin des traitements"
	else
	    echo "-> le package jdk n'existe pas, installation annulée"
	    exit
	fi

}

#------------------------------------------------------------------------------

# fonction qui permet l'installation de TOMCAT
function_install_tomcat()
{

echo "VC_DESTINATIONTOMCAT_REP : "$VC_DESTINATIONTOMCAT_REP
echo "VC_DIRTCAT : "$VC_DIRTCAT
VC_DESTINATIONTOMCAT_REP=$VC_DIRTCAT
echo "VC_DESTINATIONTOMCAT_REP : "$VC_DESTINATIONTOMCAT_REP

        echo " "
        echo "Installation de TOMCAT"
	if [ -f $VC_DIRLOC/$VC_ORIGINETOMCAT_REP/$VC_ORIGINETOMCAT_FILE ]
	then

            echo "-> traitement en cours, veuillez patienter ..."
            echo "-> copie des fichiers d'installation ..."
            rm -rf $VC_INSTTMC
            sleep 3
            mkdir $VC_INSTTMC
            sleep 1
	    cp -fr $VC_DIRLOC/$VC_ORIGINETOMCAT_REP $VC_INSTTMC
            echo "-> Decompactage ..."
            cd $VC_INSTTMC/tomcat
            chmod 777 $VC_ORIGINETOMCAT_FILE       
            tar xvzf $VC_ORIGINETOMCAT_FILE
            echo "-> installation de TOMCAT en cours ..."
	    echo "- creation du repertoire de tomcat : "$VC_DESTINATIONTOMCAT_REP
		mkdir $VC_DESTINATIONTOMCAT_REP
	    sleep 1
		echo "-> copie du package tomcat de "$VC_ORIGINETOMCAT_PACK" vers "$VC_DESTINATIONTOMCAT_REP
	    cp -fr $VC_ORIGINETOMCAT_PACK/* $VC_DESTINATIONTOMCAT_REP
            sleep 3
            chmod 777 $VC_DESTINATIONTOMCAT_REP
            chmod 777 -R $VC_DESTINATIONTOMCAT_REP/*
            echo "-> creation du demarrage automatique ..."
	    cd $VC_DIRLOC
            sed 's/COGIS-INSTALL-CHEMIN-JRE/'$VC_DESTINATIONJRE_SED'/g' $VC_DIRLOC/scripts/tomcat/vtp-tomcat > /etc/init.d/$VC_NOMSERVICE_TOMCAT
	    sed -i 's/COGIS-INSTALL-CHEMIN-TOMCAT/'$VC_DESTINATIONTOMCAT_SED'/g' /etc/init.d/$VC_NOMSERVICE_TOMCAT
            chmod 755 /etc/init.d/$VC_NOMSERVICE_TOMCAT
            ln -sf /etc/init.d/$VC_NOMSERVICE_TOMCAT /etc/rc0.d/K95$VC_NOMSERVICE_TOMCAT
            ln -sf /etc/init.d/$VC_NOMSERVICE_TOMCAT /etc/rc1.d/K95$VC_NOMSERVICE_TOMCAT
            ln -sf /etc/init.d/$VC_NOMSERVICE_TOMCAT /etc/rc2.d/S95$VC_NOMSERVICE_TOMCAT
            ln -sf /etc/init.d/$VC_NOMSERVICE_TOMCAT /etc/rc3.d/S95$VC_NOMSERVICE_TOMCAT
            ln -sf /etc/init.d/$VC_NOMSERVICE_TOMCAT /etc/rc4.d/S95$VC_NOMSERVICE_TOMCAT
            ln -sf /etc/init.d/$VC_NOMSERVICE_TOMCAT /etc/rc5.d/S95$VC_NOMSERVICE_TOMCAT
            ln -sf /etc/init.d/$VC_NOMSERVICE_TOMCAT /etc/rc6.d/K95$VC_NOMSERVICE_TOMCAT
            sleep 3
            echo "-> modification du paramétrage de catalina ..."
 	    if [ $VC_TOTMEM -lt 2883584 ]
	    then
		if [ "$VC_C2ICOMPACT" = "1" ]
		then
			# si C2ICOMPACT
			sed -i '2iJAVA_OPTS=" -Xms256m -Xmx768m -XX:PermSize=128m -XX:MaxPermSize=128m"' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
		else
			# si pas C2ICOMPACT
			sed -i '2iJAVA_OPTS=" -Xms256m -Xmx1024m -XX:PermSize=128m -XX:MaxPermSize=128m"' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
		fi
	    elif [ $VC_TOTMEM -lt 3932160 ]
	    then
		sed -i '2iJAVA_OPTS=" -Xms384m -Xmx1536m -XX:PermSize=128m -XX:MaxPermSize=128m"' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
	    else
		sed -i '2iJAVA_OPTS=" -Xms512m -Xmx2048m -XX:PermSize=128m -XX:MaxPermSize=128m"' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
	    fi



echo "parametre -Dfile.encoding"
TEMPVAR=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS | grep -c "\-Dfile.encoding")
if [ "$TEMPVAR" = "0" ]
then
	echo "parametre existe pas on le cree"
	sed -i -e 's/^JAVA_OPTS.*$/& -Dfile.encoding=UTF-8/g' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
else
	echo "parametre existe"
fi

echo "parametre -Duser.country"
TEMPVAR=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS | grep -c "\-Duser.country")
if [ "$TEMPVAR" = "0" ]
then
	echo "parametre existe pas on le cree"
	sed -i -e 's/^JAVA_OPTS.*$/& -Duser.country=FR/g' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
else
	echo "parametre existe"
fi

echo "parametre -Duser.language"
TEMPVAR=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS | grep -c "\-Duser.language")
if [ "$TEMPVAR" = "0" ]
then
	echo "parametre existe pas on le cree"
	sed -i -e 's/^JAVA_OPTS.*$/& -Duser.language=fr/g' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
else
	echo "parametre existe"
fi

echo "parametre -Duser.region"
TEMPVAR=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS | grep -c "\-Duser.region")
if [ "$TEMPVAR" = "0" ]
then
	echo "parametre existe pas on le cree"
	sed -i -e 's/^JAVA_OPTS.*$/& -Duser.region=FR/g' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
else
	echo "parametre existe"
fi


VC_VARA=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS= | sed -e 's/\"//g')
echo "VC_VARA :"$VC_VARA

VC_VARB=${VC_VARA:10}
echo "VC_VARB :"$VC_VARB

#suppression ligne JAVA_OPTS
sed -i '/^JAVA_OPTS/d' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh

VC_VARC='JAVA_OPTS="'$VC_VARB'"'
echo "VC_VARC : "$VC_VARC

sed -i "1i\\$VC_VARC" $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh



            sleep 1
	    sed -i '2iJAVA_HOME="'$VC_DESTINATIONJRE_SED'"' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
            sleep 1
            sed -i '2iJRE_HOME="'$VC_DESTINATIONJRE_SED'"' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
            sleep 3
	    echo "-> modification des ports d'ecoute ..."
	    echo "-> génération du certificat"
	    $VC_DESTINATIONJRE_REP/$VC_DESTINATIONJRE_PACK/bin/keytool -genkey -alias VisualTaxeWeb -keyalg RSA -validity 36500 -dname "cn=cogis,ou=cogis,o=cogis,c=FR" -storepass cogis94 -keypass cogis94 -keystore $VC_DESTINATIONTOMCAT_REP/conf/cogis.keystore
sleep 15
	    if [ -f $VC_DESTINATIONTOMCAT_REP/conf/cogis.keystore ]
	    then
		echo "-> réussite génération certificat"
		cp -fr $VC_DIRLOC/scripts/tomcat/server.xml $VC_DESTINATIONTOMCAT_REP/conf/server.xml
	    else
		echo "-> échec génération certificat"
		sed -i 's/port="8080"/port="8888"/g' $VC_DESTINATIONTOMCAT_REP/conf/server.xml
	    fi
            sleep 3
	    echo "-> copie de tomcat-users"
	    cp -fr $VC_DIRLOC/scripts/tomcat/tomcat-users.xml $VC_DESTINATIONTOMCAT_REP/conf/tomcat-users.xml
	    echo "-> modification du timeout"
	    sed -i 's/<session-timeout>30<\/session-timeout>/<session-timeout>30<\/session-timeout>/g' $VC_DESTINATIONTOMCAT_REP/conf/web.xml
	    echo "-> suppression des applications exemples"
	    rm -rf $VC_DESTINATIONTOMCAT_REP/webapps/examples
	    rm -rf $VC_DESTINATIONTOMCAT_REP/work/Catalina/localhost/examples
	    sleep 10
            echo "-> suppression des fichiers d'installation ..."
            rm -rf $VC_INSTTMC
	    VC_MODIF_TOMCAT="O"
            echo "-> fin des traitements"
	else
	    echo "-> le package tomcat n'existe pas, installation de tomcat annulee"
	fi

}

#------------------------------------------------------------------------------

# fonction qui permet l'installation de POSTGRESQL
function_install_postgresql()
{

        echo " "       
        echo "Installation de POSTGRESQL"
	if [ -f $VC_DIRLOC/$VC_ORIGINEPSQL_REP/$VC_ORIGINEPSQL_FILE ]
	then
            echo "-> traitement en cours, veuillez patienter ..."
            echo "-> copie des fichiers d'installation ..."
            rm -rf $VC_INSTSQL
            sleep 3
            mkdir $VC_INSTSQL
            sleep 1
            cp $VC_DIRLOC/$VC_ORIGINEPSQL_REP -R $VC_INSTSQL
            echo "-> installation ..."
            cd $VC_INSTSQL/postgresql
            chmod 777 $VC_ORIGINEPSQL_FILE
            ./$VC_ORIGINEPSQL_FILE --mode unattended  --prefix $VC_DIRSQL --datadir $VC_DIRSQL/data --superpassword admin --serverport 5499 --servicename vtp-postgre
            #sh /root/tutu.sh
            sleep 3
            echo "-> suppression des fichiers d'installation ..."
	    cd $VC_DIRLOC
            rm -rf $VC_INSTSQL
	    VC_MODIF_POSTGRE="O"
            echo "-> fin des traitements"
	else
	    echo "-> le package postgresql n'existe pas, installation de postgresql annulee"
	fi

}

#------------------------------------------------------------------------------

# fonction qui permet de désinstaller postgre
function_desinstall_POSTGRE()
{

echo "Desinstallation de POSTGRESQL"
echo "  -> desinstallation en cours ..."
$VC_DIRSQL/uninstall-postgresql --mode unattended > /dev/null
sleep 15
rm -f /root/.pgpass
rm -f /root/.pgadmin3
rm -rf $VC_DIRSQL

#on retire LD_LIBRARY_PATH
sed -i '/^export LD_LIBRARY_PATH/d' /root/.bashrc

}

#------------------------------------------------------------------------------

# fonction qui permet d'arreter postgre
function_stop_postgre()
{

sh /etc/init.d/$VC_NOMSERVICE_POSTGRESQL stop
sleep 15

}

#------------------------------------------------------------------------------

# fonction qui permet de detecter le chemin de TOMCAT
function_detect_tomcat()
{

VC_CHEMIN_DETECTION_TOMCAT=""
VC_SERVICE_DETECTION_TOMCAT=""
if [ -d /usr/local/tomcat ]
then
	VC_CHEMIN_DETECTION_TOMCAT=/usr/local/tomcat
	VC_SERVICE_DETECTION_TOMCAT=tomcat
fi
if [ -d /usr/local/vtp-tomcat ]
then
	VC_CHEMIN_DETECTION_TOMCAT=/usr/local/vtp-tomcat
	VC_SERVICE_DETECTION_TOMCAT=vtp-tomcat
fi
echo "-> chemin de tomcat détecté : "$VC_CHEMIN_DETECTION_TOMCAT
echo "-> nom du service de tomcat détecté : "$VC_SERVICE_DETECTION_TOMCAT

}

#------------------------------------------------------------------------------

# fonction qui permet de desinstaller TOMCAT
function_desinstall_tomcat()
{

echo "Desinstallation de TOMCAT"
echo "-> desinstallation de TOMCAT en cours ..."
function_stop_tomcat
if [ "$VC_CHEMIN_DETECTION_TOMCAT" != "" ]
then
	VC_DESTINATIONTOMCAT_REP=$VC_CHEMIN_DETECTION_TOMCAT
fi
rm -rf $VC_DESTINATIONTOMCAT_REP
#if  [ -f /etc/init.d/$VC_NOMSERVICE_TOMCAT ]
#then
    rm -f /etc/rc0.d/K95$VC_NOMSERVICE_TOMCAT
    rm -f /etc/rc1.d/K95$VC_NOMSERVICE_TOMCAT
    rm -f /etc/rc2.d/S95$VC_NOMSERVICE_TOMCAT
    rm -f /etc/rc3.d/S95$VC_NOMSERVICE_TOMCAT
    rm -f /etc/rc4.d/S95$VC_NOMSERVICE_TOMCAT
    rm -f /etc/rc5.d/S95$VC_NOMSERVICE_TOMCAT
    rm -f /etc/rc6.d/K95$VC_NOMSERVICE_TOMCAT
    rm -f /etc/init.d/$VC_NOMSERVICE_TOMCAT
#else
#    rm -f /etc/rc0.d/K95tomcat
#    rm -f /etc/rc1.d/K95tomcat
#    rm -f /etc/rc2.d/S95tomcat
#    rm -f /etc/rc3.d/S95tomcat
#    rm -f /etc/rc4.d/S95tomcat
#    rm -f /etc/rc5.d/S95tomcat
#    rm -f /etc/rc6.d/K95tomcat
#    rm -f /etc/init.d/tomcat	    
#fi
rm -rf $VC_DESTINATIONTOMCAT_REP

}

#------------------------------------------------------------------------------

# fonction qui créé les bases vierges
function_creation_bases_vierges()
{

echo " "
echo "Creation de l'environnement"
echo "-> copie de PGPASS ..."
cp -f $VC_DIRLOC/scripts/postgresql/pgpass /root/.pgpass
chmod 600 -R /root/.pgpass
echo "-> creation de l'utilisateur et de la base ..."
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U postgres -f $VC_DIRLOC/scripts/postgresql/vtpro-psql
echo "-> restauration du schema CONFIG de la base courante"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_config.backup 
sleep 3
echo "-> restauration du schema STATS de la base courante"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_stats.backup 
sleep 3
echo "-> restauration du schema QUARTZ de la base courante"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_quartz.backup 
sleep 3
echo "-> restauration du schema ROOM de la base courante"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_room.backup 
sleep 3
echo "-> restauration du schema STATS de la base archivee n°1"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a1' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_stats.backup 
sleep 3
echo "-> restauration du schema CONFIG de la base archivee n°1"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a1' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_config.backup 
sleep 3
echo "-> restauration du schema QUARTZ de la base archivee n°1"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a1' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_quartz.backup 
sleep 3
echo "-> restauration du schema ROOM de la base archivee n°1"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a1' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_room.backup 
sleep 3
echo "-> restauration du schema STATS de la base archivee n°2"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a2' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_stats.backup 
sleep 3
echo "-> restauration du schema CONFIG de la base archivee n°2"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a2' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_config.backup 
sleep 3
echo "-> restauration du schema QUARTZ de la base archivee n°2"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a2' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_quartz.backup 
sleep 3
echo "-> restauration du schema ROOM de la base archivee n°2"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a2' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_room.backup 
sleep 3
echo "-> restauration du schema STATS de la base archivee n°3"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a3' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_stats.backup 
sleep 3
echo "-> restauration du schema CONFIG de la base archivee n°3"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a3' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_config.backup 
sleep 3
echo "-> restauration du schema QUARTZ de la base archivee n°3"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a3' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_quartz.backup 
sleep 3
echo "-> restauration du schema ROOM de la base archivee n°3"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a3' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_room.backup 
sleep 3
echo "-> gestion utilisateur ODBC"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U sa1 -d visual_taxe_pro -f $VC_DIRLOC/scripts/postgresql/odbc-psql
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U sa1 -d visual_taxe_pro_a1 -f $VC_DIRLOC/scripts/postgresql/odbc-psql
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U sa1 -d visual_taxe_pro_a2 -f $VC_DIRLOC/scripts/postgresql/odbc-psql
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U sa1 -d visual_taxe_pro_a3 -f $VC_DIRLOC/scripts/postgresql/odbc-psql
echo "-> fin du traitement"

}

#------------------------------------------------------------------------------

# fonction qui permet de désinstaller JRE
function_desinstall_jre()
{

echo "- desinstallation de JRE"
function_detect_jre_jdk
echo "VC_TEMPPACKAGE_JRE : "$VC_TEMPPACKAGE_JRE
rm -rf $VC_TEMPPACKAGE_JRE

}

#------------------------------------------------------------------------------

# fonction qui permet la mise à jour de VTP
function_majnormale_VTP()
{

# suppression d'anciennes lignes erronées
sed -i '/^VTP_JAVA_HOME=\$/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '/^VTP_JAVA_HOME=\$/d' /etc/init.d/$VC_NOMSERVICE_TOMCAT
sed -i '/^export VTP_JAVA_HOME/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '/^export JAVA_HOME/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '/^PATH/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '/^export VTP_CATALINA_BASE=\$/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '/^export VTP_PG_HOME/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '/^export LD_LIBRARY_PATH/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER

# ajout des lignes
sed -i '1a\export VTP_PG_HOME='$VC_DIRSQL/bin /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
#sed -i '1a\export LD_LIBRARY_PATH='$VC_DIRSQL/lib /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '1a\export VTP_JAVA_HOME='$VC_DIRJRE /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '2a\export JAVA_HOME=$VTP_JAVA_HOME' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '3a\PATH=\/sbin:\/usr\/sbin:\/bin:\/usr\/bin:$VTP_JAVA_HOME\/bin\/' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
# on met à jour DAEMON dans vtp-manager
# on calcul la position de la ligne
V_LIGNEDAEMONVTPMANAGER=$(sed -n '/^DAEMON=/=' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER)
V_LIGNEDAEMONVTPMANAGER=$(($V_LIGNEDAEMONVTPMANAGER-1))
# on supprime la ligne
sed -i '/^DAEMON=/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
# on ajoute la nouvelle ligne
sed -i $V_LIGNEDAEMONVTPMANAGER'a\DAEMON=$VTP_JAVA_HOME\/bin\/java' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
# on met à jour DAEMON_ARGS dans vtp-manager
# on calcul la position de la ligne
V_LIGNEDAEMONVTPMANAGER=$(sed -n '/^DAEMON_ARGS=/=' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER)
V_LIGNEDAEMONVTPMANAGER=$(($V_LIGNEDAEMONVTPMANAGER-1))
# on supprime la ligne
sed -i '/^DAEMON_ARGS=/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
# on ajoute la nouvelle ligne
sed -i $V_LIGNEDAEMONVTPMANAGER'a\DAEMON_ARGS=" -jar $VTP_HOME\/manager.jar $VTP_HOME $VTP_JAVA_HOME\/bin\/ $VTP_PG_HOME"' /etc/init.d/vtp-manager

# Mise à jour de TOMCAT
# ici il faut mettre à jour les chemins /etc/init.d/vtp-tomcat, même si JRE pas mis à jour
# suppressions
sed -i '/^export VTP_JAVA_HOME/d' /etc/init.d/$VC_NOMSERVICE_TOMCAT
sed -i '/^export JAVA_HOME/d' /etc/init.d/$VC_NOMSERVICE_TOMCAT
sed -i '/^export VTP_CATALINA_BASE=\$/d' /etc/init.d/$VC_NOMSERVICE_TOMCAT
sed -i '/^export LD_LIBRARY_PATH/d' /etc/init.d/$VC_NOMSERVICE_TOMCAT
# ajout des lignes
sed -i '1a\export VTP_JAVA_HOME='$VC_DIRJRE /etc/init.d/$VC_NOMSERVICE_TOMCAT
sed -i '2a\export JAVA_HOME=$VTP_JAVA_HOME' /etc/init.d/$VC_NOMSERVICE_TOMCAT

# Mise à jour PACKAGES.CONF
# suppression
sed -i '/^java-version/d' /usr/local/vtp-manager/conf/packages.conf
sed -i '/^java-chemin/d' /usr/local/vtp-manager/conf/packages.conf
# ajout des lignes
sed -i '1a\java-version='$VC_VERSION_JRE /usr/local/vtp-manager/conf/packages.conf
sed -i '2a\java-chemin='$VC_DIRJRE /usr/local/vtp-manager/conf/packages.conf

# Mise à jour CATALINA.SH
# suppressions
sed -i '/^JRE_HOME=/d' /usr/local/vtp-tomcat/bin/catalina.sh
sed -i '/^JAVA_HOME=/d' /usr/local/vtp-tomcat/bin/catalina.sh
# ajout des lignes
sed -i '1a\JRE_HOME='$VC_DIRJRE /usr/local/vtp-tomcat/bin/catalina.sh
sed -i '2a\JAVA_HOME=$JRE_HOME' /usr/local/vtp-tomcat/bin/catalina.sh

#cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS= | sed -e 's/\"//g'

echo "parametre -Dfile.encoding"
TEMPVAR=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS | grep -c "\-Dfile.encoding")
if [ "$TEMPVAR" = "0" ]
then
	echo "parametre existe pas on le cree"
	sed -i -e 's/^JAVA_OPTS.*$/& -Dfile.encoding=UTF-8/g' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
else
	echo "parametre existe"
fi

echo "parametre -Duser.country"
TEMPVAR=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS | grep -c "\-Duser.country")
if [ "$TEMPVAR" = "0" ]
then
	echo "parametre existe pas on le cree"
	sed -i -e 's/^JAVA_OPTS.*$/& -Duser.country=FR/g' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
else
	echo "parametre existe"
fi

echo "parametre -Duser.language"
TEMPVAR=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS | grep -c "\-Duser.language")
if [ "$TEMPVAR" = "0" ]
then
	echo "parametre existe pas on le cree"
	sed -i -e 's/^JAVA_OPTS.*$/& -Duser.language=fr/g' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
else
	echo "parametre existe"
fi

echo "parametre -Duser.region"
TEMPVAR=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS | grep -c "\-Duser.region")
if [ "$TEMPVAR" = "0" ]
then
	echo "parametre existe pas on le cree"
	sed -i -e 's/^JAVA_OPTS.*$/& -Duser.region=FR/g' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh
else
	echo "parametre existe"
fi


VC_VARA=$(cat $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh | grep ^JAVA_OPTS= | sed -e 's/\"//g')
echo "VC_VARA :"$VC_VARA

VC_VARB=${VC_VARA:10}
echo "VC_VARB :"$VC_VARB

#suppression ligne JAVA_OPTS
sed -i '/^JAVA_OPTS/d' $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh

VC_VARC='JAVA_OPTS="'$VC_VARB'"'
echo "VC_VARC : "$VC_VARC

sed -i "1i\\$VC_VARC" $VC_DESTINATIONTOMCAT_REP/bin/catalina.sh







# confirmation mise à jour   
echo "Mise a jour de VTPRO"
echo "-> arret de VTPRO"
function_stop_vtpro
sleep 5
echo "-> arret de TOMCAT"
function_stop_tomcat
sleep 5
#function_sauve_vtpro
#sleep 5
echo "-> suppression de l'ancienne version de l'interface web"
rm -rf $VC_DESTINATIONTOMCAT_REP/webapps/VisualTaxeWeb
sleep 10
rm -rf $VC_DESTINATIONTOMCAT_REP/work/Catalina/localhost/VisualTaxeWeb
sleep 10

# on teste si vtp-manager est dispo en décompressé
# si oui on l'utilise tel quel
# si non, on utilise le tar.gz
if [ -d $VC_DIRLOC/vtp-manager ]
then
	echo "-> installeur trouve decompresse, il sera utilise"
	echo "   le fichier tar.gz est ignore"
	echo "-> copie du package ..."	
	VC_INSTVTP=$VC_DIRLOC
else
	echo "-> seul l'installeur compresse est observe, il sera utilise"
	rm -rf $VC_INSTVTP
	sleep 3
	mkdir $VC_INSTVTP
	cp -fr $VC_DIRLOC/vtp-manager.tar.gz $VC_INSTVTP
	sleep 3
	echo "-> decompression des fichiers ..."
	cd $VC_INSTVTP
	tar -xvf $VC_INSTVTP/vtp-manager.tar.gz
	sleep 5
fi
cd $VC_DIRLOC
echo "-> installation de la nouvelle version de l'interface web de vtpro"
cp -f $VC_DIRLOC/web/VisualTaxeWeb.war $VC_DESTINATIONTOMCAT_REP/webapps/
sleep 3
#echo "-> sauvegarde des fichiers de configuration"
#cp -fr /usr/local/vtp-manager/conf/conf.properties /usr/local/vtp-manager/conf/conf.properties.sauve
echo "-> suppression du répertoire lib existant"
rm -rf $VC_DIRVTPM/lib
sleep 20
echo "-> installation de la nouvelle version de vtpro"
cp -fr $VC_INSTVTP/vtp-manager /usr/local/
sleep 5
cp -fr $VC_DIRLOC/xdg $VC_DIRVTPM
#function_detect_jre_jdk
tmp0=$VC_DIRJRE
VC_DIRJRE=${tmp0//\//\\\/}
sed 's/COGIS-INSTALL-CHEMIN-JRE/'$VC_DIRJRE'/g' $VC_DIRLOC/xdg/scripts-desktop/superviseur.sh > $VC_DIRVTPM/xdg/scripts-desktop/superviseur.sh
sleep 1
cp -fr $VC_DIRLOC/doc $VC_DIRVTPM
sleep 1
VC_MODIF_VTPRO="O"
# on verifie si vtp_room doit être restauré
# pour cela, on vérifie si on trouve newbase dans backup/chambres
if [ -f $VC_DIRVTPM/backup/chambres/newbase.bak ]
then
	# la base existe déjà
	# tout est OK, rien à faire
	echo "-> le fichier $VC_DIRVTPM/backup/chambres/newbase.bak est présent"
else
	# la base n'existe pas
	echo "-> copie et restauration de la base vtp_room"
	echo "-> restauration du schema ROOM de la base courante"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_room.backup 
	sleep 3
	echo "-> restauration du schema ROOM de la base archivee n°1"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a1' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_room.backup 
	sleep 3
	echo "-> restauration du schema ROOM de la base archivee n°2"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a2' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_room.backup 
	sleep 3
	echo "-> restauration du schema ROOM de la base archivee n°3"
	LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/pg_restore -d 'visual_taxe_pro_a3' -p 5499 -U sa1 $VC_DIRVTPM/bases/vtp_room.backup 
	sleep 3
	echo "-> fin du traitement"
fi
echo "-> copie des bases vierges dans backup ..."
cp -f $VC_DIRVTPM/bases/vtp_stats.backup $VC_DIRVTPM/backup/communication/newbase.bak
cp -f $VC_DIRVTPM/bases/vtp_config.backup $VC_DIRVTPM/backup/parametrage/newbase.bak
cp -f $VC_DIRVTPM/bases/vtp_room.backup $VC_DIRVTPM/backup/chambres/newbase.bak

echo "-> restauration de conf.properties"
rm -rf $VC_DIRVTPM/conf/conf.properties.defaut
rm -rf "$VC_DIRVTPM/conf/conf alcatel oxe.ini.defaut"
rm -rf "$VC_DIRVTPM/conf/conf alcatel oxo.ini.defaut"
rm -rf "$VC_DIRVTPM/conf/conf avaya.ini.defaut"
rm -rf "$VC_DIRVTPM/conf/conf cisco.ini.defaut"
rm -rf "$VC_DIRVTPM/conf/conf tv.ini.defaut"
rm -rf "$VC_DIRVTPM/conf/conf wifi.ini.defaut"
cp -f "$VC_DIRVTPM/conf/conf.properties" "$VC_DIRVTPM/conf/conf.properties.defaut"
cp -f "$VC_DIRVTPM/conf/conf alcatel oxe.ini" "$VC_DIRVTPM/conf/conf alcatel oxe.ini.defaut"
cp -f "$VC_DIRVTPM/conf/conf alcatel oxo.ini" "$VC_DIRVTPM/conf/conf alcatel oxo.ini.defaut"
cp -f "$VC_DIRVTPM/conf/conf avaya.ini" "$VC_DIRVTPM/conf/conf avaya.ini.defaut"
cp -f "$VC_DIRVTPM/conf/conf cisco.ini" "$VC_DIRVTPM/conf/conf cisco.ini.defaut"
cp -f "$VC_DIRVTPM/conf/conf tv.ini" "$VC_DIRVTPM/conf/conf tv.ini.defaut"
cp -f "$VC_DIRVTPM/conf/conf wifi.ini" "$VC_DIRVTPM/conf/conf wifi.ini.defaut"
cp -fr ${VC_CHNOM}${VC_CHDAT}/conf/* /usr/local/vtp-manager/conf

echo "-> on supprime le répertoire saiop du package de base"
rm -rf $VC_DIRVTPM/scripts/saiop
echo "-> on copie le répertoire saiop de l'installeur"
cp -fr $VC_DIRLOC/scripts/saiop $VC_DIRVTPM/scripts/
sleep 1
chmod -R 777 $VC_DIRVTPM/scripts/
echo "-> gestion utilisateur ODBC"
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U sa1 -d visual_taxe_pro -f $VC_DIRLOC/scripts/postgresql/odbc-psql
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U sa1 -d visual_taxe_pro_a1 -f $VC_DIRLOC/scripts/postgresql/odbc-psql
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U sa1 -d visual_taxe_pro_a2 -f $VC_DIRLOC/scripts/postgresql/odbc-psql
LD_LIBRARY_PATH=$VC_DIRSQL/lib $VC_DIRSQL/bin/psql -p 5499 -U sa1 -d visual_taxe_pro_a3 -f $VC_DIRLOC/scripts/postgresql/odbc-psql
echo "-> gestion des versions logiciels ..."
function_gestion_versions
echo "-> gestion des bases vierges"
tmp0=`cat $VC_DIRVTPM/conf/packages.conf | grep 'postgre-version='`
tmp1=`expr index "$tmp0" =`
tmp2=${tmp0:$tmp1}
if [ "$tmp2" != "8.4.17-1" ]
then
	echo "-> version inférieure à 8.4.17-1"
	echo "-> suppression des nouvelles bases vierges"
	rm -rf $VC_DIRVTPM/bases/*.backup
	rm -rf $VC_DIRVTPM/backup/communication/newbase.bak
	rm -rf $VC_DIRVTPM/backup/chambres/newbase.bak
	rm -rf $VC_DIRVTPM/backup/parametrage/newbase.bak
	sleep 5
	echo "-> copie des anciennes bases vierges"	
	cp -f $VC_DIRLOC/anciennes-bases/8.3/*.backup $VC_DIRVTPM/bases
	cp -f $VC_DIRLOC/anciennes-bases/8.3/vtp_config.backup $VC_DIRVTPM/backup/parametrage/newbase.bak
	cp -f $VC_DIRLOC/anciennes-bases/8.3/vtp_room.backup $VC_DIRVTPM/backup/chambres/newbase.bak
	cp -f $VC_DIRLOC/anciennes-bases/8.3/vtp_stats.backup $VC_DIRVTPM/backup/communication/newbase.bak
else
	echo "-> version supérieure ou égale à 8.4.17-1, on ne modifie pas les bases"
fi

echo "-> mise a jour de /etc/init.d/tomcat : VTP_CATALINA_HOME"
sed -i '/^export VTP_CATALINA_HOME/d' /etc/init.d/$VC_NOMSERVICE_TOMCAT
sed -i '1a\export VTP_CATALINA_HOME='$VC_DESTINATIONTOMCAT_SED /etc/init.d/$VC_NOMSERVICE_TOMCAT

echo "-> mise a jour de /etc/init.d/vtp-tomcat : PATH"
sed -i 's/:$PATH/:$VTP_CATALINA_HOME:$VTP_JAVA_HOME:$PATH/g' /etc/init.d/$VC_NOMSERVICE_TOMCAT

echo "-> mise a jour de /etc/init.d/vtp-manager : VTP_CATALINA_HOME"
sed -i '/^export VTP_CATALINA_HOME/d' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
sed -i '1a\export VTP_CATALINA_HOME='$VC_DESTINATIONTOMCAT_SED /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
echo "-> mise a jour de /etc/init.d/vtp-manager : PATH"
sed -i 's/:$PATH/:$VTP_CATALINA_HOME:$VTP_JAVA_HOME:$PATH/g' /etc/init.d/$VC_NOMSERVICE_VTPMANAGER
}

#------------------------------------------------------------------------------

# fonction qui permet de faire mise à jour 4.x -> 4.4
function_majmajeure44()
{

# on sauvegarde les chemins par défaut des applications
VC_SAUVE_DIRVTPM=$VC_DIRVTPM
VC_SAUVE_DIRSQL=$VC_DIRSQL
VC_SAUVE_DIRTCAT=$VC_DIRTCAT
VC_SAUVE_ORIGINEJRE_PACK=$VC_ORIGINEJRE_PACK
VC_SAUVE_DESTINATIONJRE_PACK=$VC_DESTINATIONJRE_PACK
VC_SAUVE_DESTINATIONJRE_REP=$VC_DESTINATIONJRE_REP
VC_SAUVE_DESTINATIONJRE_SED=$VC_DESTINATIONJRE_SED
VC_SAUVE_TEMPPACKAGEJRE=$VC_TEMPPACKAGEJRE

VC_SAUVE_NOMSERVICE_TOMCAT="vtp-tomcat"
VC_SAUVE_NOMSERVICE_POSTGRESQL="vtp-postgre"
VC_SAUVE_NOMSERVICE_VTPMANAGER="vtp-manager"

# détection de l'emplacement de TOMCAT
function_detect_tomcat
# on met à jour les variables de TOMCAT
VC_DIRTCAT=$VC_CHEMIN_DETECTION_TOMCAT
VC_NOMSERVICE_TOMCAT=$VC_SERVICE_DETECTION_TOMCAT

# detection de POSTGRESQL
function_detect_chemin_postgresql
# on met à jour la variable qui contient le chemin
VC_DIRSQL=$VC_DETECTION_CHEMIN_PSQL
VC_NOMSERVICE_POSTGRESQL=$VC_DETECTION_SERVICE_PSQL

# arret de VTPRO
echo " "
echo "Mise a jour majeure - Arret de VTPRO"
function_stop_vtpro
sleep 5

# arret de TOMCAT
echo " "
echo "Mise a jour majeure - Arret de TOMCAT"
function_stop_tomcat
sleep 5

# sauvegarde des bases
echo " "
echo "Mise a jour majeure - Sauvegarde des bases"
function_sauve_vtpro
sleep 5

# arret de POSTGRE
echo " "
echo "Mise a jour majeure - Arret de POSTGRE"
function_stop_postgre

# désinstallation TOMCAT
echo " "
echo "Mise a jour majeure - Desinstallation de TOMCAT"
function_detect_tomcat
function_desinstall_tomcat

# désinstallation POSTGRE
echo " "
echo "Mise a jour majeure - Desinstallation de POSTGRE"
function_detect_chemin_postgresql
function_desinstall_POSTGRE

# désinstallation JRE
echo " "
echo "Mise a jour majeure - Desinstallation de JRE"
function_desinstall_jre

# installation POSTGRE
echo " "
echo "Mise a jour majeure - Installation de POSTGRE"
sleep 30
VC_DIRSQL=$VC_SAUVE_DIRSQL
VC_NOMSERVICE_POSTGRESQL=$VC_SAUVE_NOMSERVICE_POSTGRESQL
function_install_postgresql

#installation JRE
echo " "
echo "Mise a jour majeure - Installation de JRE"
VC_ORIGINEJRE_PACK=$VC_SAUVE_ORIGINEJRE_PACK
VC_DESTINATIONJRE_PACK=$VC_SAUVE_DESTINATIONJRE_PACK
VC_DESTINATIONJRE_REP=$VC_SAUVE_DESTINATIONJRE_REP
VC_DESTINATIONJRE_SED=$VC_SAUVE_DESTINATIONJRE_SED
VC_TEMPPACKAGEJRE=$VC_SAUVE_TEMPPACKAGEJRE
function_install_jre

# installation TOMCAT
echo " "
echo "Mise a jour majeure - Installation de TOMCAT"
VC_DIRTCAT=$VC_SAUVE_DIRTCAT
VC_NOMSERVICE_TOMCAT=$VC_SAUVE_NOMSERVICE_TOMCAT
echo "VC_DIRTCAT : "$VC_DIRTCAT
echo "VC_NOMSERVICE_TOMCAT : "$VC_NOMSERVICE_TOMCAT
function_install_tomcat

# restauration des bases vierges
echo " "
echo "Mise a jour majeure - Restauration des bases vierges"
function_creation_bases_vierges

# restauration bases d'origine
sleep 20
function_restauration_sauvegardes

# arret de TOMCAT
echo " "
echo "Mise a jour majeure - Arret de TOMCAT"
function_stop_tomcat
sleep 5

# mise à jour de VTP
echo " "
echo "Mise a jour majeure - Arret de TOMCAT"
function_majnormale_VTP

function_gestion_modif_postgresql_install

# on relance VTP
echo " "
echo "Mise a jour majeure - Demarrage de VTP"
function_start_vtpmanager
sleep 15
# on relance TOMCAT
echo " "
echo "Mise a jour majeure - Demarrage de TOMCAT"
function_start_tomcat
sleep 15

}



#==============================================================================
# SCRIPT PRINCIPAL
#==============================================================================

# analyse des arguments pour voir si on force l'installation/maj/désinstallation
echo "Script instal/desinstall/maj"
echo "Argument recu sur la ligne de commande : "$*
VC_CMDPROG=""
if [[ $* = *"-install"* ]]; then
	VC_CMDPROG="install"
	VCINSTALL="1"
	echo "Argument retenu : "$VC_CMDPROG
fi
if [[ $* = *"-uninstall"* ]]; then
	VC_CMDPROG="uninstall"
	VCINSTALL="4"
	echo "Argument retenu : "$VC_CMDPROG
fi
if [[ $* = *"-update"* ]]; then
	VC_CMDPROG="update"
	VCINSTALL="3"
	echo "Argument retenu : "$VC_CMDPROG
fi

# on vérifie si install c2icompact
VC_C2ICOMPACT=0
if [[ $* = *"-c2icompact"* ]]; then
	VC_C2ICOMPACT=1
	echo "Argument -c2icompact détecté"
else
	echo "Argument -c2icompact non détecté"
fi

# on vérifie si install vtpbox
VC_VTPBOX=0
if [[ $* = *"-vtpbox"* ]]; then
	VC_VTPBOX=1
	echo "Argument -vtpbox détecté"
else
	echo "Argument -vtpbox non détecté"
fi

# Vérifier si on est root, si ce n'est pas le cas on quitte
clear
if [ $(whoami) != 'root' ]; then
    echo " "
    echo "Vous devez etre super-utilisateur pour executer ce script."
    echo "ou lancez ce script à l'aide de su ou sudo."
    echo "L'installation est annulee."
    echo " "
    echo "Appuyez sur <enter> pour continuer."
    read V
    exit 0
fi

# verification si AM7450 est installé
echo " "
echo "Vérification de la présence de AASTRA AM7450 !!!"
if [ -d /home/m7450 ]
then
	echo "-> Le serveur AASTRA AM7450 a ete detecte"
	VC_AM7450=1	
else
	echo "-> Le serveur AASTRA AM7450 n'a pas ete detecte"
	VC_AM7450=0
fi

#detection de la distribution linux
function_detection_linux
if [ "$VFINSUPPORT" = "1" ]
then
	VCINSTALL="99999"
	until [ "$VCINSTALL" = "1" -o "$VCINSTALL" = "2" ]
	do
		echo " "
		echo "Le systeme d'exploitation detecte n'est plus supporte."
		echo "Etes-vous certain de vouloir continuer sur ce systeme d'exploitation ?"
		echo "1 - Oui continuer avec ce systeme d'exploitation"
		echo "2 - Non (installation annulee)"
		echo -n "Votre choix ? "
		read VCINSTALL
	done
	if [ "$VCINSTALL" = "2" ]
	then
		echo " "
		echo "Installation annulee"
		exit
	fi
fi

# Indication de la version de VTPRO
echo " "
echo " "
if [ -d $VC_DIRLOC/outils32 ]
then
	echo "Installation de VISUAL TAXE PRO (VTPRO) version "$VC_VERSION_VTPRO
else

	if [ -d $VC_DIRLOC/outils64 ]
	then
		echo "Installation de VISUAL TAXE PRO (VTPRO) version "$VC_VERSION_VTPRO
	else
		echo "Mise a jour de VISUAL TAXE PRO (VTPRO) en version "$VC_VERSION_VTPRO
	fi
fi

# Choix du type d'installation
echo " "

if [ "$VC_CMDPROG" = "" ]
then

VCINSTALL="99999"
until [ "$VCINSTALL" = "0" -o "$VCINSTALL" = "1" -o "$VCINSTALL" = "2" -o "$VCINSTALL" = "3" -o "$VCINSTALL" = "4" -o "$VCINSTALL" = "5"  -o "$VCINSTALL" = "6" ]
do
    echo "Indiquez le type de traitement que vous desirez effectuer :"
    # si pas de repertoire outil, pas de choix installation
    if [ -d $VC_DIRLOC/outils32 ]
    then
	    echo "1 - Installation automatique"
	    echo "2 - Installation pas a pas"
    else
	    if [ -d $VC_DIRLOC/outils64 ]
	    then
	       echo "1 - Installation automatique"
	       echo "2 - Installation pas a pas"
            fi
    fi
    echo "3 - Mise a jour"
    echo "4 - Desinstallation automatique"
    echo "5 - Desinstallation pas à pas"
    if [ "$VC_AM7450" = "1" ]
    then
	    echo "6 - Intégration https via AM7450"
    fi
    echo "0 - Quitter (installation annulee)"
    echo -n "Votre choix ? "
    read VCINSTALL
done

fi

#verification 32/64 bits
echo " "
echo "Détection du système 32 ou 64 bits"
VC_DETECT3264=$(getconf LONG_BIT)
echo "-> le résultat est : " $VC_DETECT3264
if [ "$VC_DETECT3264" = "64" ]
then
    	echo "-> distribution détectée en 64 bits"
	# on vérifie que le répertoire 64 bits des outils existe
	if [ "$VCINSTALL" = "1" -o "$VCINSTALL" = "2" ]
	then	
		if [ -d $VC_DIRLOC/outils64 ]
		then
			# le répertoire existe tout est OK
			echo ""
		else
			# le répertoire n'existe pas
			echo "-> attention, le repertoire outils64 n'existe pas au sein de l'installeur"
			echo "   impossible de continuer"
			echo ""
			echo "   Fin du programme."
			echo ""
			echo "Appuyez sur <enter> pour continuer."
			read V
			exit 0
		fi
	fi
else
    	VC_DETECT3264="32"
    	echo "-> distribution détectée en 32 bits, système supporté"
	# on vérifie que le répertoire 32 bits des outils existe
	if [ "$VCINSTALL" = "1" -o "$VCINSTALL" = "2" ]
	then	
		if [ -d $VC_DIRLOC/outils32 ]; then
			# le répertoire existe tout est OK
			echo ""
		else
			# le répertoire n'existe pas
			echo "-> attention, le repertoire outils32 n'existe pas au sein de l'installeur"
			echo "   impossible de continuer"
			echo ""
			echo "   Fin du programme."
			echo ""
			echo "Appuyez sur <enter> pour continuer."
			read V
			exit 0
		fi
	fi
fi

# modification de certaines variables selon 32 ou 64 bits
function_gestion_variables_3264

# Installation
if [ "$VCINSTALL" = "1" -o "$VCINSTALL" = "2" ]
then

    if [ "$VCINSTALL" = "1" ]
    then
	VC_DETECTINSTALL=0
	echo " "
	echo "Vérification de l'existance d'une précédente installation ..."
	# On vérifie que tomcat n'est pas déjà installé dans le même répertoire
	if [ -d $VC_DESTINATIONTOMCAT_REP ]
	then
		echo "-> tomcat est présent"
		VC_DETECTINSTALL=1
	else	
		echo "-> tomcat n'a pas été trouvé"
	fi
	# On vérifie que vtp-manager n'est pas déjà installé dans le même répertoire
	if [ -d /usr/local/vtp-manager ]
	then
		echo "-> vtp-manager est présent"
		VC_DETECTINSTALL=1
	else	
		echo "-> vtp-manager n'a pas été trouvé"
	fi
	# On vérifie que postgre n'est pas déjà installé dans le même répertoire
	if [ -f $VC_DIRSQL/bin/pg_restore ]
	then
		echo "-> postgre est présent"
		VC_DETECTINSTALL=1
	else	
		echo "-> postgre n'a pas été trouvé"
	fi
	# Résultat
	if [ "$VC_DETECTINSTALL" = "1" ]
	then
		echo " "
		echo "Installation impossible, le logiciel semble déjà installé"
		echo "Désinstallez le logiciel avant de le réinstaller"
		echo "Fin du programme"
		echo " "
		echo " "
		echo "Appuyez sur la touche <enter> pour continuer."
		read V
		exit 0
	else
		echo " "
		echo "Le programme n'a pas été détecté, l'installation peut continuer".
	fi
    fi

    # Detection de la mémoire
    function_detection_memoire

    # Installation de JRE
    if [ "$VCINSTALL" = "2" ]
    then
        # installation manuelle   
	VMESSAGECONFIRMATION="Desirez-vous installer JRE ... ?"
	function_dialogue_confirmation
    else
        # installation automatique
        VCREP=1
    fi
    if [ $VCREP = 1 ]
    then
	function_install_jre
	VC_MODIF_JRE="O"
    fi

    # Installation de Tomcat
    if [ "$VCINSTALL" = "2" ]
    then
        # installation manuelle   
	VMESSAGECONFIRMATION="Desirez-vous installer TOMCAT ... ?"
	function_dialogue_confirmation
    else
        # installation automatique
        VCREP=1
    fi
    if [ $VCREP = 1 ]
    then
	function_install_tomcat
    fi

    # POSTGRESQL
    if [ "$VCINSTALL" = "2" ]
    then
        # installation manuelle   
	VMESSAGECONFIRMATION="Desirez-vous installer POSTGRESQL ... ?"
	function_dialogue_confirmation
    else
        # installation automatique
        VCREP=1
    fi
    if [ $VCREP = 1 ]
    then
	function_install_postgresql
    fi

    # VTPRO
    if [ "$VCINSTALL" = "2" ]
    then
        # installation manuelle   
	VMESSAGECONFIRMATION="Desirez-vous installer VISUAL TAXE PRO ... ?"
	function_dialogue_confirmation
    else
        # installation automatique
        VCREP=1
    fi
    if [ $VCREP = 1 ]
    then
        echo " "
        echo "Installation de VTPRO"
        echo "-> traitement en cours, veuillez patienter ..."

	# on teste si vtp-manager est dispo en décompressé
	# si oui on l'utilise tel quel
	# si non, on utilise le tar.gz
	if [ -d $VC_DIRLOC/vtp-manager ]
	then
		echo "-> installeur trouve decompresse, il sera utilise"
		echo "   le fichier tar.gz est ignore"
	        echo "-> copie du package ..."	
		VC_INSTVTP=$VC_DIRLOC
	else
		echo "-> seul l'installeur compresse est observe, il sera utilise"
		rm -rf $VC_INSTVTP
		sleep 3
		mkdir $VC_INSTVTP
		cp -fr $VC_DIRLOC/vtp-manager.tar.gz $VC_INSTVTP
		sleep 3
	        echo "-> decompression des fichiers ..."
		cd $VC_INSTVTP
		tar -xvf $VC_INSTVTP/vtp-manager.tar.gz
		sleep 5
	fi
	cd $VC_DIRLOC
        echo "-> installation des composants ..."
	cp -fr $VC_INSTVTP/vtp-manager /usr/local/
	sleep 5
	cp -fr $VC_DIRLOC/xdg $VC_DIRVTPM
	sed 's/COGIS-INSTALL-CHEMIN-JRE/'$VC_DESTINATIONJRE_SED'/g' $VC_DIRLOC/xdg/scripts-desktop/superviseur.sh > $VC_DIRVTPM/xdg/scripts-desktop/superviseur.sh
	sleep 1
	cp -f $VC_DIRLOC/scripts/vtp-manager/packages.conf $VC_DIRVTPM/conf/
        echo "-> copie des documentations ..."
	cp -fr $VC_DIRLOC/doc $VC_DIRVTPM
	sleep 1
        echo "-> modification des droits ..."
	chmod 777 -R $VC_DIRVTPM/xdg
	chmod 777 -R $VC_DIRVTPM/doc
        chmod 666 -R -f $VC_DIRVTPM/data/* > /dev/null
        chmod 666 -R $VC_DIRVTPM/conf/*
        chmod 777 $VC_DIRVTPM/collecteur.jar
        chmod 777 $VC_DIRVTPM/manager.jar
        chmod 777 $VC_DIRVTPM/telecollecteur.jar
        chmod 777 $VC_DIRVTPM/superviseur.jar
        echo "-> creation du demarrage automatique ..."
        VC_TEMPSTRING=$VC_DESTINATIONJRE_REP\/$VC_ORIGINEJRE_PACK
        if [ "$VCOS" = "1" ]
        then
            #cp -f $VC_DIRLOC/scripts/vtp-manager/redhat/vtp-manager /etc/init.d/
            sed 's/COGIS-INSTALL-CHEMIN-JRE/'$VC_DESTINATIONJRE_SED'/g' $VC_DIRLOC/scripts/vtp-manager/redhat/vtp-manager > /etc/init.d/vtp-manager
            sed -i 's/COGIS-INSTALL-CHEMIN-TOMCAT/'$VC_DESTINATIONTOMCAT_SED'/g' /etc/init.d/vtp-manager

        else
            #cp -f $VC_DIRLOC/scripts/vtp-manager/debian/vtp-manager /etc/init.d/
            sed 's/COGIS-INSTALL-CHEMIN-JRE/'$VC_DESTINATIONJRE_SED'/g' $VC_DIRLOC/scripts/vtp-manager/debian/vtp-manager > /etc/init.d/vtp-manager
            sed -i 's/COGIS-INSTALL-CHEMIN-TOMCAT/'$VC_DESTINATIONTOMCAT_SED'/g' /etc/init.d/vtp-manager
        fi
        chmod 755 /etc/init.d/vtp-manager
        ln -sf /etc/init.d/vtp-manager /etc/rc0.d/K96vtp-manager
        ln -sf /etc/init.d/vtp-manager /etc/rc1.d/K96vtp-manager
        ln -sf /etc/init.d/vtp-manager /etc/rc2.d/S96vtp-manager
        ln -sf /etc/init.d/vtp-manager /etc/rc3.d/S96vtp-manager
        ln -sf /etc/init.d/vtp-manager /etc/rc4.d/S96vtp-manager
        ln -sf /etc/init.d/vtp-manager /etc/rc5.d/S96vtp-manager
        ln -sf /etc/init.d/vtp-manager /etc/rc6.d/K96vtp-manager
        echo "-> installation de l'application web ..."
	sleep 1
        rm -rf $VC_DESTINATIONTOMCAT_REP/webapps/VisualTaxeWeb
	sleep 5
        rm -rf $VC_DESTINATIONTOMCAT_REP/work/Catalina/localhost/VisualTaxeWeb
        sleep 5
        cp -f $VC_DIRLOC/web/VisualTaxeWeb.war $VC_DESTINATIONTOMCAT_REP/webapps/
	sleep 5
	sleep 1
        echo "-> copie des bases vierges dans backup ..."
	cp -f $VC_DIRVTPM/bases/vtp_stats.backup $VC_DIRVTPM/backup/communication/newbase.bak
	cp -f $VC_DIRVTPM/bases/vtp_config.backup $VC_DIRVTPM/backup/parametrage/newbase.bak
	cp -f $VC_DIRVTPM/bases/vtp_room.backup $VC_DIRVTPM/backup/chambres/newbase.bak
	echo "-> on supprime le répertoire saiop du package de base"
	rm -rf $VC_DIRVTPM/scripts/saiop
	echo "-> on copie le répertoire saiop de l'installeur"
	cp -fr $VC_DIRLOC/scripts/saiop $VC_DIRVTPM/scripts/
	sleep 1
	chmod -R 777 $VC_DIRVTPM/scripts/
	VC_MODIF_VTPRO="O"
	if [ -d $VC_DIRLOC/vtp-manager ]
	then
	        echo "-> pas de suppression des fichiers temporaires ..."	
	else
	        echo "-> suppression des fichiers temporaires ..."	
		rm -rf $VC_INSTVTP
	fi
        echo "-> fin des traitements"
    fi

    # CREATION SA1 ET BASES
    if [ "$VCINSTALL" = "2" ]
    then
        # installation manuelle   
	VMESSAGECONFIRMATION="Desirez-vous créer l'environnement POSTGRESQL pour VISUAL TAXE PRO/EXPRESS ?"
	function_dialogue_confirmation
    else
        # installation automatique
        VCREP=1
    fi
    if [ $VCREP = 1 ]
    then   
    	function_creation_bases_vierges
    fi

    # INTEGRATION AU SEIN de AM7450
    if [ $VC_AM7450 = 1 ]
    then
	if [ "$VCINSTALL" = "2" ]
    	then
	        # installation manuelle   
		VMESSAGECONFIRMATION="Desirez-vous integrer l'acces a VISUAL TAXE PRO au sein de AASTRA AM7450 ?"
		function_dialogue_confirmation
    	else
        	# installation automatique
	        VCREP=1
	fi
	if [ $VCREP = 1 ]
    	then
		function_integration_AM7450
    	fi
    fi

    # paramètres c2icompact
    if [ "$VC_C2ICOMPACT" = "1" ]
    then
	function_c2icompactinstall
    fi

    echo " "
    echo "Finalisation"
    echo "-> gestion des versions logiciels ..."
    function_gestion_versions
    echo "-> GESTION DES RACCOURCIS ..."
    function_raccourcis
    echo "-> modification chemin PostgreSQL ..."
    function_gestion_modif_postgresql_install
    function_corrige_conflit_postgresql8384AM7450
    echo "-> preparation des services ..."
    function_stop_vtpro
    sleep 5
    function_stop_tomcat
    sleep 5
    echo "-> demarrage du MANAGER ..."
    cd /usr/local/vtp-manager
    sleep 1
    function_start_vtpmanager
    sleep 5
    echo "-> demarrage de TOMCAT ..."
    function_start_tomcat
    sleep 5
    if [ "$VC_C2ICOMPACT" = "1" ]
    then
	function_install_vtputilc2icompact
	function_c2icompactdeleteservices
    fi
    echo "-> fin du traitement"

    echo " "
    echo "Installation terminee !"
    if [ "$VC_LOGS" != "" ]
    then
	        echo " "
	        echo "Vous pouvez trouver les logs de la mise a jour dans "$VC_LOGS
    fi

if [ "$VC_CMDPROG" != "" ]
then
    echo " "
    echo "Pour vous connecter a l'interface web du logiciel"
    echo "au sein du navigateur Firefox, rendez-vous sur l'url suivante :"
    echo " "
    if [ $VC_AM7450 = 1 ]
    then
	echo "          https://localhost/VisualTaxeWeb"
    else
	echo "          http://localhost:8888/VisualTaxeWeb"
    fi
    echo " "
    echo " "
    echo "Appuyez sur la touche <enter> pour continuer."
    read V
fi

    exit 0

fi


# Mise a jour
if [ "$VCINSTALL" = "3" ]
then

	# Detection de la mémoire
	function_detection_memoire

	#Comparaison des versions
	echo " "
	echo "Controle des versions"
	function_controle_version_vtpro
	VC_MAJMAJEURE="N"
	if [ "$VC_VERSIONPRESENTEVTP" == "" ]
	then
		$VC_VERSIONPRESENTEVTP="4.00A.00"
	fi
	if [ "$VC_VERSIONPRESENTEVTP" \> "4.40A.05" ]
	then
		VC_MAJMAJEURE="N"
		echo "Mise à jour normale"

		# Détection du chemin de PostgreSQL
		function_detect_chemin_postgresql

		function_sauve_vtpro
		
		# arret de VTPRO
		echo "-> arret de VTPRO"
		function_stop_vtpro
		sleep 5
		# arret de TOMCAT
		echo "-> arret de TOMCAT"
		function_stop_tomcat
		sleep 5

		echo "valeur de VC_TEMPPACKAGEJRE : "$VC_TEMPPACKAGEJRE

		function_majnormale_VTP

		echo "-> gestion conflits PostgreSQL 8.3/8.4"
		function_corrige_conflit_postgresql8384AM7450
		#on retire LD_LIBRARY_PATH
		sed -i '/^export LD_LIBRARY_PATH/d' /root/.bashrc

		echo "-> redemarrage du MANAGER ..."
		cd $VC_DIRVTPM
		sleep 1
		function_start_vtpmanager
		sleep 15
		echo "-> redemarrage de TOMCAT"        
		function_start_tomcat
		sleep 15

		if [ "$VC_C2ICOMPACT" = "1" ]
		then
			function_uninstall_vtputilc2icompact
			function_install_vtputilc2icompact
		fi

	else
		VC_MAJMAJEURE="O"
		echo "Mise à jour majeure"
		function_majmajeure44
	fi

	echo " "
	echo "Finalisation"
	# gestion des raccourcis
	function_raccourcis
	echo "-> suppression des fichiers d'installation" 
	if [ "$VC_INSTVTP" != "$VC_DIRLOC" ]
	then
		rm -rf $VC_INSTVTP
	fi
	sleep 1
	echo " "
	echo "Mise a jour terminee !"

	if [ "$VC_CMDPROG" != "" ]
	then	
		if [ "$VC_LOGS" != "" ]
		then
			echo " "
			echo "Vous pouvez trouver les logs de la mise a jour dans "$VC_LOGS
		fi
		echo " "
		echo "Les bases de données, sauvegardes, archives et fichiers de configuration"
		echo "de Visual Taxe Pro ont été sauvegardés avant la mise a jour"
		echo "dans "${VC_CHNOM}${VC_CHDAT}
		echo " "
		echo "Appuyez sur <enter> pour continuer."
		read V
		exit 0
	fi

fi

# Désinstallation
if [ "$VCINSTALL" = "4" -o  "$VCINSTALL" = "5" ]
then

        # Détection du chemin de PostgreSQL
        function_detect_chemin_postgresql

	# confirmation désinstallation VTPRO
	if [ "$VCINSTALL" = "5" ]
    	then
		# desinstallation manuelle
		VMESSAGECONFIRMATION="Confirmez vous la desinstallation de VISUAL TAXE PRO ?"
		function_dialogue_confirmation
	else
	 	# installation automatique
	        VCREP=1
	fi
        if [ "$VCREP" = "1" ]
        then
	    echo "Desinstallation de VTPRO"
	    echo "-> Arret du logiciel ..."	    
	    function_stop_vtpro
	    sleep 3
	    function_sauve_vtpro
	    # gestion des raccourcis
	    function_raccourcis
	    echo "-> desinstallation en cours ..."
            rm -fr /usr/local/vtp-manager
            rm -f /etc/rc0.d/K96vtp-manager
            rm -f /etc/rc1.d/K96vtp-manager
            rm -f /etc/rc2.d/S96vtp-manager
            rm -f /etc/rc3.d/S96vtp-manager
            rm -f /etc/rc4.d/S96vtp-manager
            rm -f /etc/rc5.d/S96vtp-manager
            rm -f /etc/rc6.d/K96vtp-manager
            rm -f /etc/init.d/vtp-manager
        fi

        # confirmation désinstallation TOMCAT
	if [ "$VCINSTALL" = "5" ]
    	then
        	# desinstallation manuelle   
		VMESSAGECONFIRMATION="Confirmez vous la desinstallation de TOMCAT ?"
		function_dialogue_confirmation
	else
	 	# installation automatique
        	VCREP=1
	fi
        if [ "$VCREP" = "1" ]
        then   
		function_desinstall_tomcat		
        fi

        # confirmation désinstallation JDK
	if [ "$VCINSTALL" = "5" ]
    	then
        	# desinstallation manuelle   
		VMESSAGECONFIRMATION="Confirmez vous la desinstallation de JDK ?"
		function_dialogue_confirmation
	else
	 	# installation automatique
        	VCREP=1
	fi
        if [ "$VCREP" = "1" ]
        then   
	        echo "Desinstallation de JDK"
        	echo "  -> desinstallation en cours ..."
		function_detect_jre_jdk
        	rm -rf $VC_DESTINATIONJRE_REP/$VC_ORIGINEJRE_PACK
		sleep 5
        fi

        # confirmation désinstallation POSTGRESQL
	if [ "$VCINSTALL" = "5" ]
    	then
        	# desinstallation manuelle   
		VMESSAGECONFIRMATION="Confirmez vous la desinstallation de POSTGRESQL ?"
		function_dialogue_confirmation
	else
	 	# installation automatique
        	VCREP=1
	fi
        if [ "$VCREP" = "1" ]
        then   
		function_desinstall_POSTGRE
		#on retire LD_LIBRARY_PATH
		sed -i '/^export LD_LIBRARY_PATH/d' /root/.bashrc
        fi

    	# INTEGRATION AU SEIN de AM7450
	if [ $VC_AM7450 = 1 ]
	then
	        # confirmation désinstallation integration AM7450
		if [ "$VCINSTALL" = "5" ]
	    	then
			# desinstallation manuelle   
			VMESSAGECONFIRMATION="Desirez-vous supprimer de APACHE l'integration TOMCAT ?"
			function_dialogue_confirmation
		else
		 	# installation automatique
	        	VCREP=1
		fi
		if [ $VCREP = 1 ]
	    	then
	        	echo " "
		        echo "Suppression de l'integration de TOMCAT sur APACHE"
		        echo "-> modification de ssl.conf ..."
			sed -i '/JkMount \/VisualTaxeWeb/d' /etc/httpd/conf.d/ssl.conf
		        echo "-> suppression des fichiers ..."
			rm -f /etc/httpd/modules/mod_jk.so
			rm -f /etc/httpd/conf.d/vtpro.conf
			rm -f /etc/httpd/conf/worker.properties
			echo "-> relance de AM7450 sans coupure des connexions courantes ..."
			sh /etc/init.d/httpd reload > /dev/null
		        echo "-> fin du traitement"
		fi
    	fi

	if [ -d /var/www/cogis-vtputil ]
	then
		function_uninstall_vtputilc2icompact
	fi

	if [ -d /usr/local/vtp-jre ]
	then
		function_desinstall_jre
	fi

        echo " "
	echo "Desinstallation terminee !"

	if [ "$VC_CMDPROG" != "" ]
	then

		if [ "$VC_LOGS" != "" ]
		then
		        echo " "
		        echo "Vous pouvez trouver les logs de la desinstallation dans "$VC_LOGS
		fi
        	echo " "
        	echo "Les bases de données, sauvegardes, archives et fichiers de configuration"
		echo "de Visual Taxe Pro ont été sauvegardes dans "${VC_CHNOM}${VC_CHDAT}
		echo " "
		echo "Appuyez sur <enter> pour continuer."
		read V
		exit 0

	fi

fi

# Intégration de l'accès à VTPRO en HTTPS via AM7450
if [ "$VCINSTALL" = "6" ]
then
	function_integration_AM7450
        echo "L'intégration est terminée"
	echo " "
	echo "Appuyez sur <enter> pour continuer."
	read V
	exit 0
fi

# quitter
if [ "$VCINSTALL" = "0" ]
then
	exit 0
fi
